///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THCONFIG_H
#define SHARED_THCONFIG_H
///////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef __GNUC__
	#error This configuration header is handwritten for Microsoft Visual Studio.NET, and cannot be used with the GNU tools!
#endif

/* Define if you have the `acos' function. */
#define HAVE_ACOS 1

/* Define if you have the `asin' function. */
#define HAVE_ASIN 1

/* Define if you have the `atan' function. */
#define HAVE_ATAN 1

/* Define if you have the `atof' function. */
#define HAVE_ATOF 1

/* Define if you have the `cos' function. */
#define HAVE_COS 1

/* Define if you have the <ctype.h> header file. */
#define HAVE_CTYPE_H 1

/* Define if you have the <GL/glu.h> header file. */
#define HAVE_GL_GLU_H 1

/* Define if you have the <GL/gl.h> header file. */
#define HAVE_GL_GL_H 1

/* Define if you have the <limits.h> header file. */
#define HAVE_LIMITS_H 1

/* Define if your system has a working `malloc' function. */
#define HAVE_MALLOC 1

/* Define if you have the <math.h> header file. */
#define HAVE_MATH_H 1

/* Define if you have the `memcpy' function. */
#define HAVE_MEMCPY 1

/* Define if you have the `memset' function. */
#define HAVE_MEMSET 1

/* Define if you have the `sin' function. */
#define HAVE_SIN 1

/* Define if you have the `snprintf' function. */
#define HAVE_SNPRINTF 1

/* Define if you have the `sprintf' function. */
#define HAVE_SPRINTF 1

/* Define if you have the `sqrt' function. */
#define HAVE_SQRT 1

/* Define if you have the <stdio.h> header file. */
#define HAVE_STDIO_H 1

/* Define if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H 1

/* Define if you have the <stdarg.h> header file. */
#define HAVE_STDARG_H 1

/* Define if you have the <string.h> header file. */
#define HAVE_STRING_H 1

/* Define if you have the <direct.h> header file. */
#define HAVE_DIRECT_H 1

/* Define if you have the `strcasecmp' function. */
#define HAVE_STRCASECMP 1

/* Define if you have the `strcat' function. */
#define HAVE_STRCAT 1

/* Define if you have the `strchr' function. */
#define HAVE_STRCHR 1

/* Define if you have the `strcmp' function. */
#define HAVE_STRCMP 1

/* Define if you have the `strcpy' function. */
#define HAVE_STRCPY 1

/* Define if you have the `strlen' function. */
#define HAVE_STRLEN 1

/* Define if you have the `strlwr' function. */
#define HAVE_STRLWR 1

/* Define if you have the `strrchr' function. */
#define HAVE_STRRCHR 1

/* Define if you have the `strstr' function. */
#define HAVE_STRSTR 1

/* Define if you have the `strtol' function. */
#define HAVE_STRTOL 1

/* Define if you have the `strupr' function. */
#define HAVE_STRUPR 1

/* Define if you have the `tan' function. */
#define HAVE_TAN 1

/* Define if you have the <time.h> header file. */
#define HAVE_TIME_H 1

/* Define if you have the `tolower' function. */
#define HAVE_TOLOWER 1

/* Define if you have the `toupper' function. */
#define HAVE_TOUPPER 1

/* Define if you have the `vsnprintf' function. */
#define HAVE_VSNPRINTF 1

/* Define if you have the `vsprintf' function. */
#define HAVE_VSPRINTF 1

/* Name of package */
#define PACKAGE "theresa"

/* Size of static text buffers. */
#define THERESA_BUFFER_SIZE 2048

/* Default resolution color depth. */
#define THERESA_DEFAULT_DEPTH 16

/* Default resolution height. */
#define THERESA_DEFAULT_HEIGHT 480

/* Default resolution width. */
#define THERESA_DEFAULT_WIDTH 640

/* Default windowed setting. */
#define THERESA_DEFAULT_WINDOWED true

/* Platform is little-endian */
#define THERESA_LITTLE_ENDIAN 1

/* Minimum resolution color depth. */
#define THERESA_MINIMUM_DEPTH 16

/* Minimum resolution height. */
#define THERESA_MINIMUM_HEIGHT 240

/* Minimum resolution width. */
#define THERESA_MINIMUM_WIDTH 320

/* Default line-break sequence. */
#define THERESA_NEWLINE "\r\n"

/* Build for the WGL/Win32 platform */
#define THERESA_WGL 1

/* Build with the Visual Studio environment */
#define THERESA_VISUALSTUDIO 1

/* Version number of package */
#define VERSION "0.5.1"

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THCONFIG_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
