///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Example program for the Theresa library
// Copyright (C) 2003 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <Theresa.h>

#include "Simple.h"

bool SimpleApp::render(IThCanvas* target)
{
	// make the canvas current
	target->apply();

	// clear the screen to bright red
	glClearColor(1.f, 0.f, 0.f, 0.f);
	glClear(GL_COLOR_BUFFER_BIT);
	
	// update the canvas' contents to screen
	target->update();

	// NOTE: returning false is a request for delayed deletion.
	return true;
}

int main(int argc, char** argv)
{
	// initalise library, set up global objects
	if (!initializeTheresa(argc, argv))
		return -1;
		
	if (System->openDisplay())
	{
		// NOTE: this does NOT cause a memory leak, since
		// the class derives from ThServerObject, and all
		// such instances are managed automatically.
		new SimpleApp();

		// start system loop
		System->start();
		
		// close display window (not strictly necessary)
		System->closeDisplay();
	}

	// shut down library
	shutdownTheresa();
	
	return 0;
}
