///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THCORE_H
#define SHARED_THCORE_H
///////////////////////////////////////////////////////////////////////////////////////////////////

// include platform-specific configuration header
#include "ThConfig.h"

///////////////////////////////////////////////////////////////////////////////////////////////////

#define THFLAG(x) (1 << (x))
#define THSWAP2(x) (((x) << 8) | ((x) >> 8))
#define THSWAP4(x) ((((x) & 0xff) << 24) | (((x) & 0xff00) << 8) | (((x) & 0xff0000) >> 8) | (((x) & 0xff000000) >> 24))

// TODO: implement!
#define THSWAP8(x) (x)

// NOTE: this line needs to be aware of all platforms.
#if !THERESA_WGL && !THERESA_AGL && !THERESA_GLX && !THERESA_SDL
	#error You must specify a platform!
#endif

#if THERESA_SDL
	// include main-redirection header
	#include <SDL_main.h>
#endif

// define compatible function names
#if THERESA_VISUALSTUDIO
	#define strcasecmp stricmp
	#define snprintf _snprintf
	#define vsnprintf _vsnprintf
#endif

#if THERESA_DEBUG_BUILD
	#define THASSERT(expression, message) { while (!(expression)) if (!assertExpression(#expression, message, __FILE__, __LINE__)) break; }
	#define THDEBUG(x) x
#elif THERESA_RELEASE_BUILD
	#define THASSERT(expression, message)
	#define THDEBUG(x) 0
#else
	#error You must specify a build configuration!
#endif

#ifndef NULL
	#define NULL 0
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////

/*! Generic function pointer type, for Standard C++ compability.
 */
typedef void (*ThEntryPoint)(void);

///////////////////////////////////////////////////////////////////////////////////////////////////

// ThMemory ---------------------------------------------------------------------------------------

template <typename T>
class ThPtr;
template <typename T>
class ThRef;
template <typename T>
class ThRefObject;
template <typename T>
class ThBlock;
template <typename T>
class ThListItem;
template <typename T>
class ThList;
template <typename T>
class ThHashItem;
template <typename T, unsigned int N>
class ThHashList;
template <typename T>
class ThIterator;
template <typename T>
class ThConstIterator;
template <typename T>
class ThSingleton;

class IThStaticBlock;
class IThDynamicBlock;

// ThMath -----------------------------------------------------------------------------------------

template <typename T>
class ThRange;
template <typename T, unsigned int N>
class ThSpace;
class ThVector2;
class ThVector3;
class ThVector4;
class ThMatrix3;
class ThMatrix4;
class ThArea;
class ThSphere;

// ThTimer ----------------------------------------------------------------------------------------

class ThTimer;

// ThString ---------------------------------------------------------------------------------------

class ThString;
class ThStringItem;
class ThStringList;

// ThError ----------------------------------------------------------------------------------------

class IThError;

// ThScript ---------------------------------------------------------------------------------------

class ThToken;

class IThSymbolTable;
class IThTokenizer;
class IThAnalyzer;
class IThSyntax;

// ThStream ---------------------------------------------------------------------------------------

class IThStream;

// ThStorage --------------------------------------------------------------------------------------

class IThStorage;

// ThServer ---------------------------------------------------------------------------------------

class ThServerObject;
class ThClient;

class IThMessage;
class IThServer;

// ThContext --------------------------------------------------------------------------------------

class ThResolution;
class ThContextMode;

class IThContext;

// ThDisplay --------------------------------------------------------------------------------------

class ThSprite2;
class ThSprite3;
class ThDisplayObject;

class IThSurface;
class IThTexture;
class IThDisplayList;
class IThCanvas;
class IThDisplay;

// ThMusic ----------------------------------------------------------------------------------------

class IThMusic;

// ThEngine ---------------------------------------------------------------------------------------

class ThVertex;
class ThTriangle;
class ThGeometry;

class ThMeshData;
class ThLightData;
class ThMaterialData;

class ThEngineNode;

class IThMesh;
class IThLight;
class IThMaterial;
class IThEngine;

// ThParticle -------------------------------------------------------------------------------------

class ThParticle;
class ThParticleEmitter;
class ThParticleSystem;

// ThEffect ---------------------------------------------------------------------------------------

class ThEffectType;
template <typename T>
class ThEffectTemplate;
class ThEffectObject;

class IThEffect;

// ThSystem ---------------------------------------------------------------------------------------

class ThApplication;

class IThSystem;

///////////////////////////////////////////////////////////////////////////////////////////////////

/*! Retrieves the name of the operating system.
 *	\return A static string describing the current operating system.
 */
const char* getPlatformName(void);

#if THERESA_DEBUG_BUILD

/*! Writes a message to the platform-specific debug output.
 *	\param message [in]The message to write.
 */
void writeDebugMessage(const char* message);

/*! Displays an assertion failure message.
 *	\param expression [in]The failed expression.
 *	\param message [in]The description of the error.
 *	\param fileName [in]The name of the file containing the error.
 *	\param line [in]The line where the error occurred.
 *	\return \c true if the user chose to try again, or \c false if the user chose to abort the operation.
 */
bool assertExpression(const char* expression, const char* message, const char* fileName, unsigned int line);

#endif

///////////////////////////////////////////////////////////////////////////////////////////////////

/*! \class ThException
 * Exception information class.
 */
/*! \fn ThException::ThException(const char* message, const char* fileName, unsigned int line)
 *	Constructor. Creates an exception information object with the specified values.
 *	\param message [in]The message describing the thrown exception.
 *	\param fileName [in]The file name from which the exception was thrown.
 *	\param line [in]The line from which the exception was thrown.
 */
/*! \fn const char* ThException::getMessage(void) const
 *	\return The message describing the thrown exception.
 */
/*! \fn const char* ThException::getFileName(void) const
 *	\return The file name from which the exception was thrown.
 */
/*! \fn unsigned int ThException::getLine(void) const
 *	\return The line from which the exception was thrown.
 */
class ThException
{
public:
// constructors
																		ThException(const char* message, const char* fileName, unsigned int line);
// attributes
	const char*												getMessage(void) const;
	const char*												getFileName(void) const;
	unsigned int											getLine(void) const;
private:
// data
	const char*												m_message;
	const char*												m_fileName;
	unsigned int											m_line;
};

///////////////////////////////////////////////////////////////////////////////////////////////////

/*! \class IThCriticalSection
 *	Critical section. Describes a simple platform-neutral critical section object.
 */
/*! \fn IThCriticalSection::~IThCriticalSection(void)
 *	Destructor.
 */
/*! \fn void IThCriticalSection::begin(void)
 *	Requests ownership of the object for the current thread. This call may block if another thread currently has ownership.
 */
/*! \fn void IThCriticalSection::end(void)
 *	Releases ownership of the object for the current thread.
 */
/*! \fn IThCriticalSection* IThCriticalSection::createInstance(void)
 *	Creates and returns an instance of a critical section object.
 *	\return The newly created critical section object.
 */
class IThCriticalSection
{
public:
// constructors
	virtual														~IThCriticalSection(void);
// methods
	virtual void											begin(void) = 0;
	virtual void											end(void) = 0;
// static methods
	static IThCriticalSection*				createInstance(void);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class IThMutex
{
public:
// constructors
	virtual														~IThMutex(void);
// methods
	virtual bool											request(float timeout = 0.f) = 0;
	virtual void											release(void) = 0;
// static methods
	static IThMutex*									createInstance(void);
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THCORE_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
