///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THDISPLAY_H
#define SHARED_THDISPLAY_H
///////////////////////////////////////////////////////////////////////////////////////////////////

enum
{
	THLAYER_INVALID,
	
	THLAYER_CLEAR,
	THLAYER_BACKGROUND,
	THLAYER_NORMAL,
	THLAYER_FOREGROUND,
	THLAYER_TOPMOST,
	THLAYER_SYSTEM,
	
	THLAYER_CUSTOM_BASE = 1000,
};

enum
{
	THTEX_MIPMAP,
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThSprite2
{
public:
// constructors
																		ThSprite2(void);
// methods
	void															render(void);
// data
	ThVector2													m_position;
	ThVector2													m_size;
	ThArea														m_area;
	ThVector4													m_color;
	float															m_rotation;
};

//-------------------------------------------------------------------------------------------------

class ThSprite3
{
public:
// constructors
																		ThSprite3(void);
// methods
	void															render(void);
// data
	ThVector3													m_position;
	ThVector2													m_size;
	ThArea														m_area;
	ThVector4													m_color;
	float															m_rotation;
};

//-------------------------------------------------------------------------------------------------

class ThDisplayObject : public ThListItem<ThDisplayObject>
{
public:
// constructors
																		ThDisplayObject(void);
	virtual														~ThDisplayObject(void);
// methods
	void															show(void);
	void															hide(void);
// callbacks
	virtual bool											update(float deltaTime) = 0;
	virtual bool											render(IThCanvas* target) = 0;
// attributes
	bool															isVisible(void) const;
private:
// data
	bool															m_visible;
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class IThSurface
{
public:
// constructors
	virtual														~IThSurface(void);
// methods
	virtual void*											lock(void) = 0;
	virtual void											unlock(void) = 0;
// attributes
	virtual unsigned int							getWidth(void) const = 0;
	virtual unsigned int							getHeight(void) const = 0;
	virtual unsigned int							getType(void) const = 0;
	virtual unsigned int							getFormat(void) const = 0;
	virtual const char*								getName(void) const = 0;
	virtual unsigned int							getHash(void) const = 0;
};

//-------------------------------------------------------------------------------------------------

class IThTexture
{
public:
// constructors
	virtual														~IThTexture(void);
// methods
	virtual void											apply(void) = 0;
// attributes
	virtual unsigned int							getWidth(void) const = 0;
	virtual unsigned int							getHeight(void) const = 0;
	virtual unsigned int							getFormat(void) const = 0;
	virtual const char*								getName(void) const = 0;
	virtual unsigned int							getHash(void) const = 0;
};

//-------------------------------------------------------------------------------------------------

class IThDisplayList
{
public:
// constructors
	virtual														~IThDisplayList(void);
// methods
	virtual void											begin(void) = 0;
	virtual void											end(void) = 0;
	virtual void											render(void) = 0;
};

//-------------------------------------------------------------------------------------------------

class IThCanvas
{
public:
// constructors
	virtual														~IThCanvas(void);
// methods
	virtual void											apply(void) = 0;
	virtual void											update(void) = 0;
// attributes
	virtual unsigned int							getWidth(void) const = 0;
	virtual unsigned int							getHeight(void) const = 0;
};

//-------------------------------------------------------------------------------------------------

class IThDisplay
{
public:
// constructors
	virtual														~IThDisplay(void);  
// object methods
	virtual IThSurface*								createSurface(const char* fileName) = 0;
	virtual IThSurface*								createSurface(IThStream* stream, const char* name = NULL) = 0;
	virtual IThSurface*								createSurface(unsigned int width, unsigned int height, unsigned int type, unsigned int format, const char* name = NULL) = 0;
	virtual IThSurface*								findSurface(const char* name) = 0;
	virtual IThSurface*								findSurface(unsigned int hash) = 0;
	virtual IThTexture*								createTexture(const char* fileName, unsigned int format, unsigned int flags = 0) = 0;
	virtual IThTexture*								createTexture(IThStream* stream, unsigned int format, unsigned int flags = 0, const char* name = NULL) = 0;
	virtual IThTexture*								createTexture(IThSurface* surface, unsigned int format, unsigned int flags = 0, const char* name = NULL) = 0;
	virtual IThTexture*								findTexture(const char* name) = 0;
	virtual IThTexture*								findTexture(unsigned int hash) = 0;
	virtual IThDisplayList*						createDisplayList(void) = 0;
	virtual IThTexture*								createCanvasTexture(unsigned int width, unsigned int height, const char* name = NULL) = 0;
	virtual IThCanvas*								createTextureCanvas(IThTexture* texture) = 0;
	virtual IThCanvas*								createVirtualCanvas(unsigned int width, unsigned int height) = 0;
// object methods
	virtual bool											registerLayer(unsigned int id) = 0;
	virtual bool											registerObject(ThDisplayObject* object, unsigned int layerID) = 0;
	virtual void											renderObjects(IThCanvas* target = NULL, unsigned int layerID = THLAYER_INVALID) = 0;
	virtual void											releaseObjects(void) = 0;
// attributes
	virtual IThContext*								getContext(void) = 0;
	virtual IThTexture*								getDefaultTexture(void) = 0;
	virtual IThCanvas*								getDefaultCanvas(void) = 0;
// static methods
	static IThDisplay*								createInstance(const ThContextMode* mode = NULL);
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THDISPLAY_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
