///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THERROR_H
#define SHARED_THERROR_H
///////////////////////////////////////////////////////////////////////////////////////////////////

void displayErrorMessage(const char* message, const char* description);

///////////////////////////////////////////////////////////////////////////////////////////////////

class IThError
{
public:
// constructors
	virtual														~IThError(void);
// methods
	virtual void											write(const char* name, const char* format, ...) = 0;
	virtual void											display(const char* name, const char* format, ...) = 0;
// static methods
	static bool												create(void);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

extern ThSingleton<IThError> Error;

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THERROR_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
