///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <shared/ThCore.h>
#include <shared/ThMemory.h>
#include <shared/ThTimer.h>
#include <shared/ThError.h>
#include <shared/ThServer.h>

#include <Carbon/Carbon.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

static unsigned int s_listenerID = THID_INVALID;

///////////////////////////////////////////////////////////////////////////////////////////////////

static pascal void timerCallback(EventLoopTimerRef timer, void* userData);

///////////////////////////////////////////////////////////////////////////////////////////////////

void startSystemMessageLoop(unsigned int listenerID)
{
	EventLoopTimerUPP timerUPP;
	EventLoopTimerRef timer;

	s_listenerID = listenerID;
	if (s_listenerID != THID_INVALID)
	{
		timerUPP = NewEventLoopTimerUPP(timerCallback);
		
		if (InstallEventLoopTimer(GetMainEventLoop(), 0.0, 1.0 / 60.0, timerUPP, NULL, &timer) != noErr)
		{
			Error->display("Server", "Unable to install listener timer.");

			DisposeEventLoopTimerUPP(timerUPP);
			return;
		}
	}
	
	RunApplicationEventLoop();
	
	if (timer)
	{
		Server->sendMessage(THMSG_SERVER_STOP, listenerID, THID_SERVER);

		RemoveEventLoopTimer(timer);
		DisposeEventLoopTimerUPP(timerUPP);
	}
}

void stopSystemMessageLoop(void)
{
	QuitApplicationEventLoop();
}

static pascal void timerCallback(EventLoopTimerRef timer, void* userData)
{
	Server->sendMessage(THMSG_SERVER_UPDATE, THID_SERVER, THID_SERVER);
	Server->sendMessage(THMSG_SERVER_UPDATE, s_listenerID, THID_SERVER);
}

///////////////////////////////////////////////////////////////////////////////////////////////////
