///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <shared/ThCore.h>

#include <theresa/GLX/ThCore.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

const char* getPlatformName(void)
{
	static char platformName[THERESA_BUFFER_SIZE];

	strcpy(platformName, "Unix GLX/X11");

	utsname name;

	if (uname(&name))
		return platformName;

	char versionName[THERESA_BUFFER_SIZE];

	if (snprintf(versionName, sizeof(versionName), "%s %s (%s)", name.sysname, name.release, name.machine) < 0)
		versionName[sizeof(versionName) - 1] = '\0';

	strncat(platformName, versionName, sizeof(platformName) - strlen(platformName) - 1);

	return platformName;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef THERESA_DEBUG_BUILD

//! \note This function may not use \b any system code.
void writeDebugMessage(const char* message)
{
	fprintf(stderr, "%s%s", message, THERESA_NEWLINE)
}

//! \note This function may not use \b any system code.
bool assertExpression(const char* expression, const char* message, const char* fileName, unsigned int line)
{
	static char buffer[THERESA_BUFFER_SIZE];

	if (_snprintf(buffer, sizeof(buffer), "Assertion failed!%s%sExpression: %s%sFile: %s%sLine: %u%s%s%s", THERESA_NEWLINE, THERESA_NEWLINE, expression, THERESA_NEWLINE, fileName, THERESA_NEWLINE, line, THERESA_NEWLINE, THERESA_NEWLINE, message) < 0)
		buffer[sizeof(buffer) - 1] = '\0';

	writeDebugMessage(buffer);

	exit(0);

	return true;
}

#endif /* THERESA_DEBUG_BUILD */

///////////////////////////////////////////////////////////////////////////////////////////////////
