///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THMUSIC_H
#define THERESA_THMUSIC_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThMusic : public IThMusic, public ThServerObject
{
public:
// constructors
																		ThMusic(void);
																		~ThMusic(void);
// methods
	bool															open(IThStream* source);
	void															close(void);
// interface methods
	void															start(void);
	void															stop(void);
	void															pause(void);
	void															resume(void);
// interface attributes
	bool															isStarted(void) const;
	bool															isPaused(void) const;
	float															getTime(void) const;
	bool															setTime(float time);
private:
// classes
	class Signal;
// callbacks
	bool															receive(const IThMessage* message);
// static methods
	static void												synchCallback(FMUSIC_MODULE* module, unsigned char param);
// data
	bool															m_started;
	bool															m_paused;
	ThByteBlock												m_buffer;
	ThTimer														m_timer;
	FMUSIC_MODULE*										m_module;
	FSOUND_STREAM*										m_stream;
	int																m_channel;
	ThList<Signal>										m_signals;
	ThPtr<IThMutex>										m_mutex;
};

//-------------------------------------------------------------------------------------------------

class ThMusic::Signal : public ThListItem<Signal>
{
public:
// constructors
																		Signal(unsigned char value);
// data
	unsigned char											m_value;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THMUSIC_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
