///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THSTORAGE_H
#define THERESA_THSTORAGE_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThFileStream : public IThStream, public ThListItem<ThFileStream>
{
public:
// constructors
																		ThFileStream(FILE* file, const char* name);
																		~ThFileStream(void);
// interface methods
	unsigned int											read(void* data, unsigned int size);
	unsigned int											write(const void* data, unsigned int size);
// interface attributes
	bool															isEOF(void) const;
	bool															isReadable(void) const;
	bool															isWritable(void) const;
	unsigned int											getSize(void) const;
	unsigned int											getPosition(void) const;
	bool															setPosition(unsigned int position);
private:
// data
	FILE*															m_file;
	ThString													m_name;
};

//-------------------------------------------------------------------------------------------------

class ThRootStorage : public IThStorage
{
public:
// constructors
																		ThRootStorage(void);
																		~ThRootStorage(void);
// methods
	bool															open(void);
	void															close(void);
// interface folder methods
	bool															createFolder(const char* name);
	bool															destroyFolder(const char* name);
// interface file methods
	IThStream*												createFile(const char* name);
	IThStream*												openFile(const char* name);
	bool															cacheFile(const char* name, ThByteBlock& data);
	bool															destroyFile(const char* name);
private:
// data
	ThList<ThFileStream>							m_files;
};

//-------------------------------------------------------------------------------------------------

class ThZipStorage : public IThStorage
{
public:
// constructors
																		ThZipStorage(void);
																		~ThZipStorage(void);
// methods
	bool															open(const char* fileName, bool persistent);
	void															close(void);
// interface folder methods
	bool															createFolder(const char* name);
	bool															destroyFolder(const char* name);
// interface file methods
	IThStream*												createFile(const char* name);
	IThStream*												openFile(const char* name);
	bool															cacheFile(const char* name, ThByteBlock& data);
	bool															destroyFile(const char* name);
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THSTORAGE_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
