///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_WGL_THCONTEXT_H
#define THERESA_WGL_THCONTEXT_H
///////////////////////////////////////////////////////////////////////////////////////////////////

#define THCONTEXT_WINDOWCLASSNAME "Theresa OpenGL Context Window"

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThContextDialog : public ThDialog
{
public:
// constructors
																		ThContextDialog(const ThList<ThResolution>& resolutions);
																		~ThContextDialog(void);
// attributes
	const ThResolution&								getResolution(void) const;
private:
// callbacks
	BOOL															initialize(HWND control);
	BOOL															command(HWND control, WORD identifier, BOOL accel);
	BOOL															message(UINT message, WPARAM wParam, LPARAM lParam);
// data
	ThResolution											m_resolution;
	const ThList<ThResolution>&				m_resolutions;
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThContext : public IThContext, public ThServerObject
{
public:
// constructors
																		ThContext(void);
																		~ThContext(void);
// methods
	bool															open(const ThContextMode& mode, unsigned int listenerID);
	void															close(void);
// interface methods
	void															apply(void);
	void															update(void);
// interface extension methods
	bool															findExtension(const char* name) const;
	ThEntryPoint											findEntryPoint(const char* name) const;
// interface attributes
	const char*												getTitle(void) const;
	void															setTitle(const char* title);
	unsigned int											getWidth(void) const;
	unsigned int											getHeight(void) const;
	const ThContextMode&							getMode(void) const;
private:
// callbacks
	bool															receive(const IThMessage* message);
	LRESULT														message(UINT message, WPARAM wParam, LPARAM lParam);
// static methods
	static LRESULT CALLBACK						windowCallback(HWND window, UINT message, WPARAM wParam, LPARAM lParam);
// data
	ThContextMode											m_mode;
	ThString													m_title;
	unsigned int											m_listenerID;
	ThStringList											m_extensions;
	ATOM															m_class;
	HWND															m_window;
	HDC																m_dc;
	HGLRC															m_rc;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_WGL_THCONTEXT_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
