///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_WGL_THDIALOG_H
#define THERESA_WGL_THDIALOG_H
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <windowsx.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThDialog
{
public:
// constructors
																		ThDialog(WORD identifier);
	virtual														~ThDialog(void);
// methods
	bool															create(HWND parent = NULL);
	INT_PTR														display(HWND parent = NULL);
	void															release(INT_PTR result = IDOK);
	void															show(void);
	void															hide(void);
// message methods
	LRESULT														sendMessage(WORD identifier, UINT message, WPARAM wParam = 0, LPARAM lParam = 0);
	BOOL															postMessage(WORD identifier, UINT message, WPARAM wParam = 0, LPARAM lParam = 0);
// attributes
	bool															isCreated(void) const;
	bool															isVisible(void) const;
	HWND															getHandle(void) const;
	HWND															getControl(WORD identifier) const;
	bool															getTitle(ThString& title) const;
	void															setTitle(const char* title);
	INT_PTR														getResult(void) const;
	void															setResult(INT_PTR result);
protected:
// callbacks
	virtual BOOL											initialize(HWND control);
	virtual BOOL											command(HWND control, WORD identifier, BOOL accel);
	virtual BOOL											message(UINT message, WPARAM wParam, LPARAM lParam);
private:
// static methods
	static INT_PTR CALLBACK						dialogCallback(HWND window, UINT message, WPARAM wParam, LPARAM lParam);
// data
	WORD															m_resource;
	HWND															m_window;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_WGL_THDIALOG_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
