/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef USE_GTK // Defined in basecode/Makefile*

#include "config.h"
#include "setupwindow.h"
#include <gtk/gtk.h>
#include <iostream>

using namespace std;

// Ugly workaround
demo::config *c;

demo::setupwindow::setupwindow(int argc, char **argv, config *cfg)
{
	gtk_init(&argc, &argv);
	c = cfg;

}
gboolean delete_event_exit(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_main_quit();
	exit(0);
}

gboolean delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_main_quit();
	return FALSE;
}

void demo::setupwindow::set_soundstatus()
{
	if(c->get_sound()) c->set_sound(false);
	else if(!c->get_sound()) c->set_sound(true);
}

void demo::setupwindow::set_windowstatus()
{
	if(c->get_fullscreen()) c->set_fullscreen(false);
	else if(!c->get_fullscreen()) c->set_fullscreen(true);
}

void demo::setupwindow::set_res640()
{
	c->set_width(640);
	c->set_height(480);
}

#ifdef DEBUG
void demo::setupwindow::set_scene_0()
{
	if(c->get_scenetotal() >= 1)
		c->set_scene(0);
}

void demo::setupwindow::set_scene_1()
{
	if(c->get_scenetotal() >= 2)
		c->set_scene(1);
}

void demo::setupwindow::set_scene_2()
{
	if(c->get_scenetotal() >= 3)
		c->set_scene(2);
}

void demo::setupwindow::set_scene_3()
{
	if(c->get_scenetotal() >= 4)
		c->set_scene(3);
}

void demo::setupwindow::set_scene_all()
{
	c->set_scene(-1);
}

#endif

/*void demo::setupwindow::set_res320()
{
	c->set_width(320);
	c->set_height(240);
}*/


static GtkWidget *make_menu_item(gchar *name, GCallback callback, gpointer data)
{
    GtkWidget *item;
  
    item = gtk_menu_item_new_with_label (name);
    g_signal_connect(G_OBJECT (item), "activate", callback, (gpointer) data);
    gtk_widget_show (item);

    return item;
}

void demo::setupwindow::show()
{
	// Window
	GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window),
			"xAngle - xa-002: Scratch");
	gtk_container_set_border_width(GTK_CONTAINER(window), 10);
	
	g_signal_connect(G_OBJECT(window), "delete_event",
		G_CALLBACK(delete_event_exit), NULL);
	g_signal_connect(G_OBJECT(window), "delete_event",
		G_CALLBACK(gtk_widget_destroy), NULL);
		
	// Box
	GtkWidget *box = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), box);
	gtk_widget_show(box);
	
	// Two boxes in the main box
	GtkWidget *boxleft = gtk_vbox_new(FALSE, 10);
	GtkWidget *boxright = gtk_vbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(box), boxleft, TRUE, TRUE, 10);
	gtk_box_pack_start(GTK_BOX(box), boxright, TRUE, TRUE, 0);
	gtk_widget_show(boxleft);
	gtk_widget_show(boxright);
		
	// Three horizontal boxes in the right box
	GtkWidget *box0 = gtk_hbox_new(FALSE, 10);
	GtkWidget *box1 = gtk_hbox_new(FALSE, 10);
	GtkWidget *box2 = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(boxright), box0, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(boxright), box1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(boxright), box2, TRUE, TRUE, 0);
	gtk_widget_show(box0);
	gtk_widget_show(box1);
	gtk_widget_show(box2);

	// Text boxes
#ifndef DEBUG
	GtkWidget *lres = gtk_label_new ("Resolution:");
#endif
	GtkWidget *lleft =
		gtk_label_new("      xAngle\nxa-002: Scratch\n\n\n\n");
	
	// Check boxes
	GtkWidget *c0 = gtk_check_button_new_with_label("Windowed");
	GtkWidget *c1 = gtk_check_button_new_with_label("Sound");
	if(!c->get_fullscreen())
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c0), TRUE);
	if(c->get_sound())
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(c1), TRUE);

	g_signal_connect(G_OBJECT(c0), "clicked", G_CALLBACK(cb_window), NULL);
	g_signal_connect(G_OBJECT(c1), "clicked", G_CALLBACK(cb_sound), NULL);
	
#ifdef DEBUG
	GtkWidget *scene = gtk_label_new ("Scene:");
	// Scene select
	GtkWidget *sopt = gtk_option_menu_new();
	GtkWidget *smenu = gtk_menu_new();
	GtkWidget *sitem;	
	sitem = make_menu_item("All", G_CALLBACK(cb_scene_all), NULL);
	gtk_menu_shell_append(GTK_MENU_SHELL (smenu), sitem);
	
	if(c->get_scenetotal() >= 1) {
		sitem = make_menu_item("0", G_CALLBACK(cb_scene_0), NULL);
		gtk_menu_shell_append(GTK_MENU_SHELL (smenu), sitem);
	}
	if(c->get_scenetotal() >= 2) {
		sitem = make_menu_item("1", G_CALLBACK(cb_scene_1), NULL);
		gtk_menu_shell_append(GTK_MENU_SHELL (smenu), sitem);
	}
	if(c->get_scenetotal() >= 3) {
		sitem = make_menu_item("2", G_CALLBACK(cb_scene_2), NULL);
		gtk_menu_shell_append(GTK_MENU_SHELL (smenu), sitem);
	}
	if(c->get_scenetotal() >= 4) {	
		sitem = make_menu_item("3", G_CALLBACK(cb_scene_3), NULL);
		gtk_menu_shell_append(GTK_MENU_SHELL (smenu), sitem);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (sopt), smenu);
#endif
#ifndef DEBUG
	// Resulution select
	GtkWidget *opt = gtk_option_menu_new();
    GtkWidget *menu = gtk_menu_new();
    GtkWidget *item;
	item = make_menu_item("640x480", G_CALLBACK(cb_res_640), NULL);
    gtk_menu_shell_append(GTK_MENU_SHELL (menu), item);
/*	item = make_menu_item("320x240", G_CALLBACK(cb_res_320), NULL);
    gtk_menu_shell_append(GTK_MENU_SHELL (menu), item);*/
    gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu);
#endif
	// Exit button
	GtkWidget *bexit = gtk_button_new_with_label("Exit");
	
	g_signal_connect(G_OBJECT(bexit), "clicked",
		G_CALLBACK(delete_event_exit), NULL);
	g_signal_connect_swapped(G_OBJECT(bexit), "clicked",
		G_CALLBACK(gtk_widget_destroy), G_OBJECT(window));
	
	// Run button
	GtkWidget *brun = gtk_button_new_with_label("Run");

	g_signal_connect(G_OBJECT(brun), "clicked",
		G_CALLBACK(delete_event), NULL);
	g_signal_connect_swapped(G_OBJECT(brun), "clicked",
		G_CALLBACK(gtk_widget_destroy), G_OBJECT(window));
		
	// Pack stuff into boxes
	gtk_box_pack_start(GTK_BOX(box0), c0, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(box0), c1, TRUE, TRUE, 0);
#ifndef DEBUG
	gtk_box_pack_start(GTK_BOX(box1), lres, TRUE, TRUE, 0);
#endif
#ifdef DEBUG
	gtk_box_pack_start(GTK_BOX(box1), scene, TRUE, TRUE, 0);
#endif
#ifndef DEBUG
	gtk_box_pack_start(GTK_BOX(box1), opt, TRUE, TRUE, 0);
#endif
#ifdef DEBUG
	gtk_box_pack_start(GTK_BOX(box1), sopt, TRUE, TRUE, 0);
#endif
	gtk_box_pack_start(GTK_BOX(boxleft), lleft, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(box2), bexit, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(box2), brun, TRUE, TRUE, 0);

	// Show widgets
	gtk_widget_show(bexit);
	gtk_widget_show(brun);
	gtk_widget_show(c0);
	gtk_widget_show(c1);
#ifndef DEBUG
	gtk_widget_show(lres);
	gtk_widget_show(opt);
#endif
#ifdef DEBUG
	gtk_widget_show(scene);
	gtk_widget_show(sopt);
#endif

	gtk_widget_show(lleft);
	gtk_widget_show(window);
	
	// Wait for events
	gtk_main();
}
#endif
