/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *  Coded with inspiration and some code from ecfh - another way to scroll
 *
 */

#include "gfx_blob.h"
#include "../basecode/surface.h"
#include <stdlib.h>
#include <cmath>
#include <iostream>

using namespace std;

float demo::gfx::blob::randf()
{
	return ((float) rand ()) / RAND_MAX;
}

int demo::gfx::blob::findmin(int *a, int size)
{
	int tmp = a[0];
	
	for(int i = 0; i < size; i++)
	{
		if(a[i] <= tmp)
			tmp = a[i];
	}
	return tmp;
}

demo::gfx::blob::blob(surface *surface, int nstrips, float sradius)
{
	s = surface;
	max_strips = strips = nstrips;
	radius = sradius;
	
	width = surface->get_width();
	height = surface->get_height();
	
	// Allocate space for cordinates
	c2d = new cord2d[strips]; // Screen
	c3d = new cord3d[strips]; // 3D Space
	world = new cord3d[strips]; // World
	
	
	// Calc
	float n, x, y, z;
	
	for(int i = 0; i < strips; i++)
	{
		n = 2.0;
		while (n > 1.0)
		{
			x = randf() * 2.0 - 1.0;
			y = randf() * 2.0 - 1.0;
			z = randf() * 2.0 - 1.0;

			n = sqrt (x * x + y * y + z * z);
		}
		world[i].x = x = 1 / n * x * radius;
		world[i].y = y = 1 / n * y * radius;
		world[i].z = z = 1 / n * z * radius;
	}
	//flashcolor = (int)128<<16; + (int)164<<8 + (int)255;
	flashdata = new int[strips];
}

void demo::gfx::blob::rotate(float xa, float ya, float za, float zoom)
{
	float sx, sy, sz, cx, cy, cz, x, y, z;
	
	sx = sin(xa) * zoom;
	cx = cos(xa) * zoom;
	sy = sin(ya) * zoom;
	cy = cos(ya) * zoom;
	sz = sin(za) * zoom;
	cz = cos(za) * zoom;

	for(int i = 0; i < strips; i++)
	{
		c3d[i].x = cz * world[i].x - sz * world[i].y;
		c3d[i].y = sz * world[i].x + cz * world[i].y;

		y = c3d[i].y;
		
		c3d[i].y = cx * y - sx * world[i].z;
		if(mode == 1)
			c3d[i].z = sx * c3d[i].y + cx * world[i].z;
		else
			c3d[i].z = sx * y + cx * world[i].z;

		x = c3d[i].x;
		z = c3d[i].z;
		
		c3d[i].x = cy * x + sy * z;
		c3d[i].z = -sy * x + cy * z;
	}
}

void demo::gfx::blob::draw(int xp, int yp, float sradius, float cnt, pixel col,
	int act_mode, int used_strips, float zoomfactor, bool flash, bool flash_fillout)
{
	if(sradius) radius = sradius;
	if(xp) x = xp;
	if(yp) y = yp;
	if(col) color = col;
	if(used_strips && (used_strips <= max_strips)) strips = used_strips;
	mode = act_mode;
	
	float c, zoom;
			
	// Rotate
	c = cnt + (3.0 * sin (cnt / 500.0));
	zoom = zoomfactor + 0.0150; // zoomfactor orig 0.95
	rotate(c / 32.0, c / 20.0, c / 54.0, zoom);
	
	// Project 3dcords -> 2dcords
	for(int i = 0; i < strips; i++)
	{
		c2d[i].x = (int)(x + (c3d[i].x * (1.3 * radius) / (c3d[i].z + 384.0)));
		c2d[i].y = (int)(y + (c3d[i].y * (radius) / (c3d[i].z + 384.0)));
	}

	int xc, yc;
	pixel *p = s->lock_rectangle(0).pixels;
	
	// Get random data for flash
	if(flash)
	{	
		// Reset memory
		for(int i = 0; i < strips; i++)
		{
			flashdata[i] = 0;
		}
		
		// Get random dots
		for(int i = 0; i < strips; i++)
		{
			if(((int)(1 + randf() * 5)) == 1) // Frequency
			{
				flashdata[i] = 1;
			}
		}
	}

	// Draw
	for(int j = 0; j < strips; j++)
	{
		xc = c2d[j].x;
		yc = c2d[j].y;
	
 		
		// Only draw if pixel is inside screen
		if(!((xc <= 0) || (yc <= 0) || (xc >= width) || (yc >= height)))
		{
			// Flash
			if(flash && flashdata[j])
			{
				if(flash_fillout)
				{
					/*
					  Compare the current pos with all other and set
					  colors acordingly
					*/
					for(int i = 0; i < strips; i++)
					{
						int dx = xc - c3d[i].y;
						int dy = yc - c3d[i].x;
						int dz = c3d[j].z - c3d[i].z;
						if(dx < 0) dx = -dx;
						if(dy < 0) dy = -dy;
						if(dz < 0) dz = -dz;
						
						int c = (dx*dy*dz)/8000;
						if(c > 255)
							c = 255;
						
						p[c2d[i].x + c2d[i].y*width] = color + (int)(c<<16) + (int)(c<<8);
					}
					
					// Find the closest strip to the current flashdata
					//int min_strip = findmin(flashdata, strips);
					
					
					
				}
				else
					p[xc + yc*width] = ((int)color/255)*0xFFFFFF;
			}
			else
			{
				if(c3d[j].z > 30) {
					p[xc + yc*width] = color;
					// Extra pixels
					p[(xc+1) + (yc+1)*width] = color;
					p[(xc-1) + (yc-1)*width] = color;
				}
				else {
				
					p[xc + yc*width] = color;
				}
			}
		}
	}
	s->unlock_rectangle();	
}
