/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GFX_BLOB
#define GFX_BLOB

#include "gfx.h"
#include "../basecode/surface.h"
#include "../basecode/global.h"

namespace demo
{
	 namespace gfx
	 {
		class blob {
		public:
			blob(demo::surface *surface, int nstrips, float sradius);
			void draw(int xp, int yp, float sradius, float cnt, pixel col, 
				int act_mode, int used_strips, float zoom_factor, bool flash, bool flash_fillout);
		private:
			void perspective();
			void rotate(float xa, float ya, float za, float zoom);
			void numswap(int &a, int &b) { int tmp = a; a = b; b = tmp; }; 
			float randf();
			int findmin(int *a, int size);
			
			surface *s;
			
			//pixel flashcolor;
			int *flashdata;
		
			pixel color;
			// Cords
			vector *c3d;
			cord3d *world;
			cord2d *c2d;
			int x, y; // Center
			
			// Strips
			int strips; // Number of strips currently used
			int max_strips; // max strips we have memory allocated for
			int width, height;
			float radius;
			int rc, rsize;
			int mode; // How rotate will behave
			float *r; // Random numbers
		};
	 }
}

#endif
