/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gfx_ledboard.h"
#include <cstring>
#include <iostream>

using namespace std;

demo::gfx::ledboard::ledboard(surface *surface)
{
	s = surface;
	width = surface->get_width();
	height = surface->get_height();
	
	// Allocate and generate empty map
	map = new vline[20]; // 3 lines
	for(int i = 0; i < 20; i++)
	{
		map[i].pix = new bool[7]; // 7 pixels in each vertial line
		for(int j = 0; j < 7; j++)
		{
			map[i].pix[j] = 0; // Null pixels
		}
	}
}

void demo::gfx::ledboard::draw(pixel *p, int x, int y)
{
	for(int i = 0; i < 20; i++)
	{
		for(int j = 0; j < 7; j++)
		{
			draw_dot(p, i*15 + x, j*15 + y, map[i].pix[j]);
		}
	}
}

void demo::gfx::ledboard::set(int x, int y, bool status)
{
	map[x].pix[y] = status;
}

void demo::gfx::ledboard::draw_dot(pixel *p, int x, int y, bool status)
{
	if(status)
	{
		// Draw light green box
		for(int i = 0; i < 10; i++)
			for(int j = 0; j < 10; j++)
				p[(int)(j+x) + (int)(i+y)*width] = ((int)(255<<8));// + (int)(100<<16) + (int)100);
	}
	else
	{
		// Draw normal green box
		for(int i = 0; i < 10; i++)
			for(int j = 0; j < 10; j++)
				p[(int)(j+x) + (int)(i+y)*width] = ((int)(155<<8));
	}
	
}
