/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "../basecode/surface.h"
#include "../basecode/music.h"
#include "scene_disco.h"
#include "../gfx/gfx_blob.h"
#include "../gfx/gfx_caracter.h"
#include "../gfx/gfx_text.h"
#include "../gfx/gfx_ledboard.h"
#include <cmath>
#include <cstdlib>

float demo::scene::disco::randf()
{
	return ((float) rand ()) / RAND_MAX;
}


demo::scene::disco::disco(surface *surface)
{
	s = surface;
	static demo::gfx::blob b(s, 20000, 80);
	static demo::gfx::caracter c(s);
	static demo::gfx::text t(s);
	static demo::gfx::ledboard lb(s);
	blob = &b;
	caracter = &c;
	text = &t;
	ledboard = &lb;
	width = surface->get_width();
	height = surface->get_height();
}

int demo::scene::disco::draw(long time, demo::music *music)
{
	pixel *p = s->lock_rectangle(0).pixels;
	
	for(int y = 0; y < 480; y++)
		for(int x = 0; x < 640; x++)
			p[x + y * 640] = 0;
			
	if(time < 13940)
	{
		caracter->draw(time, p);
		//if(part < 797)
		//	part = (int)(time*0.01)+10;
		blob->draw(100, 100, 250, (time+24000)*0.05, 255, 0, 797, 0.95, true, false);
		//blob->draw(400, 100, 250, (time+24000)*0.07, 255, 1, part, 1.95, true, false);
	}
	if(time > 13940 && time < 27620)
	{	
		text->draw("Greetings goes out to...", 5*28, 5*20);
		
		if(time > 15619)
			text->draw("Odious", 6*28, 6*20);
		if(time > 17320)
			text->draw("Illuminati", 10*28, 6*20);
		if(time > 19036)
			text->draw("Glass", 16*28, 6*20);
		if(time > 20863)
			text->draw("Biss", 6*28, 7*20);
		if(time > 22464)
			text->draw("Ecfh", 9*28, 7*20);
		if(time > 24196)
			text->draw("AMC", 12*28, 7*20);
		if(time > 25896)
			text->draw("Everyone at Remedy Scenezone 2003", 2*28, 10*20);
	}
	if(time > 27620 && time < 40000)
	{
		caracter->draw(time, p);
		blob->draw(300, 100, 250, (time+24000)*0.05, 255, 1, 797, 0.95, true, false);
		
		static int goy = 1;
		static int gox = 1;
		static int yc = 60;
		static int xc = 90;
		
		if(goy == 1 && yc >= 420) goy = 2;
		if(goy == 2 && yc <= 60) goy = 1;
		if(goy == 1) yc+=20;
		if(goy == 2) yc-=20;
			
		if(gox == 1 && xc >= 560) gox = 2;
		if(gox == 2 && xc < 90) gox = 1;
		if(gox == 1) xc+=20;
		if(gox == 2) xc-=20;
		
		blob->draw(xc, yc, 156, (time+24000)*0.02, 255<<16, 1, 797, 0.95, true, false);
		blob->draw(640+-xc, yc, 156, (time+24000)*0.02, 255<<8, 1, 797, 0.95, true, false);
		blob->draw(xc, 480+-yc, 156, (time+24000)*0.02, 255, 1, 797, 0.95, true, false);
	}		
	if(time > 40000 && time < 48000)
	{
		text->draw("Due to lack of time, we've reached The End.", 0, height/2-20);
		if(time > 41000 && time < 41500)
			music->set_vol(100);
		if(time > 41500 && time < 42000)
			music->set_vol(80);
		if(time > 42000 && time < 42500)
			music->set_vol(60);
		if(time > 42500 && time < 43000)
			music->set_vol(40);
		if(time > 43500 && time < 44000)
			music->set_vol(20);
		if(time > 44000 && time < 44500)
			music->set_vol(10);
		if(time > 45000 && time < 45500)
			music->set_vol(0);		
	}
	if(time > 48000)
		return 1;
	
	s->unlock_rectangle();
	
	return 0;
}
