/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "../basecode/surface.h"
#include "../gfx/gfx_matrix.h"
#include "../gfx/gfx_blob.h"
#include "scene_matrix.h"
#include "../gfx/gfx_text.h"
#include <cmath>
#include <iostream>

using namespace std;

demo::scene::matrix::matrix(demo::surface *surface)
{
	s = surface;
	static demo::gfx::matrix m(s, 24);
	static demo::gfx::blob b(s, 20000, 80);
	static demo::gfx::text t(s);
	mx = &m;
	blob = &b;
	text = &t;
	width = surface->get_width();
	height = surface->get_height();
}

int demo::scene::matrix::draw(long time, demo::music *music)
{
	pixel *p = s->lock_rectangle(0).pixels;
	
	for(int y = 0; y < 480; y++)
		for(int x = 0; x < 640; x++)
			p[x + y * 640] = 0;
	
	static int strips = 32;	
	mx->draw(time, strips);
		
	static int parts = 0;
	static int bparts = 0;
	static int fadeout = 0;
	static float zoom = 0;		
	static int pp = 0;

	if(time < 2400)
	{
		text->draw("Code by trejs", 300, 400);
		text->draw("Graphics by damnter", 300, 420);	
	}
		
	if(time < 14000)
	{	
		if(parts < 5000)
			parts = (time-2000)*0.4;

		zoom = 1.9;
		blob->draw(500, 400, 250, time*0.01, 255, 0, parts, zoom, false, false);
	}
	if(time > 14000 && time < 18000)
	{
		if(bparts < 2000)
			bparts =  + (time-14000)*0.1;
		blob->draw(100, 100, 250, time*0.1, 255, 0, bparts, 0.95, true, false);
		blob->draw(500, 400, 250, time*0.01, 255, 0, 5000, zoom, false, false);		

	}
	if(time > 18000 && time < 20000)
	{
		blob->draw(100, 100, 250, time*0.1, 255, 0, bparts, 0.95, true, false);
		blob->draw(500, 400, 250, time*0.01, strips*8+10, 0, 5000, zoom, false, false);	
		if(strips > 0) {
			strips -= (time-18000)*0.00005;
		}
	}	
	if(time > 20000) {
		return 1;
	}
	s->unlock_rectangle();
	
	return 0; // 0 = normal, 1 = exit now!
}
