#include <windows.h>

#define square 200

int window_width = 640;
int window_height = 480;
bool windowed = false;
bool demo_run = false;
bool menu_active = true;


HWND hwnd;               /* This is the handle for our window */
HINSTANCE hInstance;


/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
char szClassName[ ] = "WindowsApp";

HWND newButton (int bNum, char* title, DWORD type, int x, int y, int mx, int my)
{
    HMENU temp = (HMENU)bNum;
    return CreateWindowEx(0,"button",title,WS_CHILD|WS_VISIBLE|type,
        x,y,mx,my,hwnd,temp,hInstance,NULL);
}

void setup ()
/*int WINAPI
WinMain (HINSTANCE hThisInstance,
         HINSTANCE hPrevInstance,
         LPSTR lpszArgument,
         int nFunsterStil)*/

{
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    hInstance=NULL;
    wincl.hInstance = NULL;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_OWNDC;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);
    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default color as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;
    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           WS_EX_TOPMOST,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           "past mosfncitioo",       /* Title Text */
           WS_CAPTION | WS_POPUPWINDOW | WS_VISIBLE, /* default window */
           (GetSystemMetrics(SM_CXSCREEN)/2)-square/2,       /* Windows decides the position */
           (GetSystemMetrics(SM_CYSCREEN)/2)-square/2,       /* where the window ends up on the screen */
           square,                 /* The programs width */
           square,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );
    ShowWindow (hwnd, SW_SHOW);

    HWND a=newButton(1,"640x480",BS_AUTORADIOBUTTON,50,20,square,20);
    SendMessage(a,BM_SETCHECK,BST_CHECKED,0);
    newButton(2,"800x600",BS_AUTORADIOBUTTON,50,40,square,20);
    newButton(3,"1024x768",BS_AUTORADIOBUTTON,50,60,square,20);
    newButton(4,"windowed",BS_AUTOCHECKBOX,50, 90,square,20);
    newButton(5,"play",BS_DEFPUSHBUTTON, 0,130,square/2-4,30);
    newButton(6,"exit",BS_DEFPUSHBUTTON, square/2-4,130,square/2-4,30);
    /*  the message loop. It will run until GetMessage() returns 0 */

    while (menu_active) {
        if (PeekMessage(&messages, 0,0,0,0)) {
            GetMessage(&messages, 0,0,0);
            TranslateMessage(&messages);
            DispatchMessage(&messages);
        }
    }
    DestroyWindow(hwnd);
    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    //return messages.wParam;
}


/*  This function is called by the Windows function DispatchMessage()  */

LRESULT CALLBACK
WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    PAINTSTRUCT ps;
    RECT mr;
    HDC hdc;
    switch (message)                  /* handle the messages */
    {
        /*case WM_DESTROY:
            demo_run=false;
            menu_active=false;
            PostQuitMessage (0); 
            break;*/
        case WM_CLOSE:
            menu_active=false;
            return 0;
            break;
            
        case WM_COMMAND:
            switch (wParam) {
                case 1:
                    window_width=640; window_height=480;
                    break;
                case 2:
                    window_width=800; window_height=600;
                    break;
                case 3:
                    window_width=1024; window_height=768;
                    break;
                case 4:
                    windowed=!windowed;
                    break;
                case 5:
                    demo_run=true;
                    menu_active=false;
                    break;
                case 6:
                    demo_run=false;
                    menu_active=false;
                    PostQuitMessage(0);
                    break;
            }
            return 0;
            break;
        default:                      /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}
