;bumpmapping vertex shader

;denne filen er Vertex Shader version 1.1
vs.1.1

;punktets posisjon plasseres i register v0
dcl_position v0

;normalen plasseres i register v1
dcl_normal v1

;teksturkoordinatene plasseres i v2
dcl_texcoord0 v2

;"tangent space"-vektorene plasseres i v7,v8,v9
dcl_tangent0 v7
dcl_tangent1 v8
dcl_tangent2 v9


;transformer punktet med hele matrisen
m4x4   oPos, v0, c4

;transformer punktet til "world space"
m4x3   r0, v0, c8

;transformer tangentene til "world space"
m3x3   r5, v7, c8
m3x3   r6, v8, c8
m3x3   r7, v9, c8

;finn vektoren fra punktet til lysets posisjon (i c51) og putt resultatet i r3
add r3.xyz, c51.xyz, -r0.xyz

;normaliser vektoren
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3.xyz, r3.xyz, r3.w

;transformer vektoren til "tangent space" og putt resultatet i oD0 (diffuse)
dp3 r4.x, r3, r5
dp3 r4.y, r3, r6
dp3 r4.z, r3, r7
mad oD0.xyz, r4.xyz, c0.z, c0.z


;finn vektoren fra punktet til kameraets posisjon (c49) og putt resultatet i r8
add r8.xyz, c49.xyz, -r0.xyz

;normaliser view-vektoren
dp3 r8.w, r8, r8
rsq r8.w, r8.w
mul r8.xyz, r8.xyz, r8.w



;transformer view-vektoren til "tangent space" og putt resultatet i oD0 (diffuse)
dp3 r9.x, r8, r5
dp3 r9.y, r8, r6
dp3 r9.z, r8, r7

;legg den sammen med lys-vektoren for  lage "half-angle"-vektor
add r9.xyz, r9.xyz, r4.xyz

;normaliser "half-angle"-vektor og legg den i oD1 (specular)
dp3 r9.w, r9, r9
rsq r9.w, r9.w
mul r9.xyz, r9.xyz, r9.w
mad oD1.xyz, r9.xyz, c0.z, c0.z


mov oT0.xy, v2.xy
mov oT1.xy, v2.xy


