/* effect.h
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _EFFECT_H
#define _EFFECT_H

#include "buffer.h"

/* An effect structure */
struct effect
{
  void (*run)(void *, long);        /* Renders the effect */
  void (*parameters)(void *, long); /* Alters the parameters of the effect */
  void (*new)(struct effect *);     /* Allocates the data structures needed for the effect */
  void (*freee)(struct effect *);   /* Frees the allocated data structures */
  void *data;                       /* (effect specific) data structure for the effect */
};
typedef struct effect effect;

/* An effect list entry structure */
struct effectlistentry
{
  struct effect *effect;            /* Effect to run */
  struct effectlistentry *next;     /* Next effect in the list */
};
typedef struct effectlistentry effectlistentry;


/* effect.c functions */
/*****************************************************************************/
/**                           PROTOTYPES                                    **/
/*****************************************************************************/
effectlistentry *effectlistentry_new(effect *, effectlistentry *);
void effectlist_free(effectlistentry *);
effect *effect_new(void (*new)(effect *), void (*parameters)(void *, long));
void effect_free(effect *);

#endif
