/* effect.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "effect.h"

/* Allocates a new effect list entry structure */
effectlistentry *effectlistentry_new(effect *effect, effectlistentry *next)
{
  effectlistentry *e=calloc(sizeof(effectlistentry), 1);

  e->effect=effect;
  e->next=next;

  return e;
}

/* Frees an effect list entry and all entries linked to it */
void effectlist_free(effectlistentry *e) {
  effectlistentry *oe;

  while(e!=NULL) {
    effect_free(e->effect);
    oe=e;
    e=e->next;
    free(oe);
  }
}

/* Allocates a new effect structure */
effect *effect_new(void (*new)(effect *), void (*parameters)(void *, long))
{
  effect *e=calloc(sizeof(effect), 1);

  new(e);
  e->parameters=parameters;

  return e;
}

/* Frees an effect structure */
void effect_free(effect *e)
{
  if(e)
  {
    if(e->freee)
      e->freee(e);

    free(e);
  }
}
