/* horizontalblur.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <string.h>
#include "effect.h"
#include "horizontalblur.h"

void horizontalblur_run(void *d, long time)
{
   horizontalblur_data *data=(horizontalblur_data *)d;
   int amount;
   unsigned long *source, *dest;
   int width, height, x, y, bufptr;

   data     = (horizontalblur_data *)d;
   amount   = data->amount;
   source   = data->source->data;
   dest     = data->dest->data;
   width    = data->dest->width;
   height   = data->dest->height;

  if(amount<=2)
    memcpy(dest, source, width*height*sizeof(unsigned long));
  else
  {
    unsigned long *range=(unsigned long *)calloc(amount, sizeof(unsigned long));

    for(y=0; y<height; y++)
    {
      int a=0, r=0, g=0, b=0;
      bufptr=0;
      memset(range, 0, amount*sizeof(unsigned long));

      /* Use pixels on the left edge instead of pixels outside the buffer */
      for(x=0; x<amount/2; x++)
      {                                      // j-run comments:
         range[bufptr]=*source;              // get leftmost pixel from current source line
         a+=(range[bufptr]&0xff000000)>>24;  //
         r+=(range[bufptr]&0xff0000)>>16;    //
         g+=(range[bufptr]&0xff00)>>8;       //
         b+=(range[bufptr++]&0xff);          // loop progress, next bufptr
         bufptr%=amount;                     // make sure bufptr is within boundaries
      }

      /* Fill in the rest of the range */
      for(x=0; x<amount/2; x++)
      {                                      // j-run comments:
         range[bufptr]=*source++;            // get pixel by pixel from current source line
         a+=(range[bufptr]&0xff000000)>>24;
         r+=(range[bufptr]&0xff0000)>>16;
         g+=(range[bufptr]&0xff00)>>8;
         b+=(range[bufptr++]&0xff);
         bufptr%=amount;
      }

      /* Normal operation, actually output data */
      for(x=0; x<width-amount/2; x++)
      {
         a-=(range[bufptr]&0xff000000)>>24;
         r-=(range[bufptr]&0xff0000)>>16;
         g-=(range[bufptr]&0xff00)>>8;
         b-=(range[bufptr]&0xff);
         range[bufptr]=*source++;
         a+=(range[bufptr]&0xff000000)>>24;
         r+=(range[bufptr]&0xff0000)>>16;
         g+=(range[bufptr]&0xff00)>>8;
         b+=(range[bufptr++]&0xff);
         *dest++=((a/amount)<<24)|((r/amount)<<16)|((g/amount)<<8)|(b/amount);
         bufptr%=amount;
      }

      /* Use pixels on the right edge instead of pixels outside the buffer */
      source--;
      for(x=0; x<amount/2; x++)
      {
         a-=(range[bufptr]&0xff000000)>>24;
         r-=(range[bufptr]&0xff0000)>>16;
         g-=(range[bufptr]&0xff00)>>8;
         b-=(range[bufptr]&0xff);
         range[bufptr]=*source;
         a+=(range[bufptr]&0xff000000)>>24;
         r+=(range[bufptr]&0xff0000)>>16;
         g+=(range[bufptr]&0xff00)>>8;
         b+=(range[bufptr++]&0xff);
         *dest++=((a/amount)<<24)|((r/amount)<<16)|((g/amount)<<8)|(b/amount);
         bufptr%=amount;
      }
      source++;
    }
    free(range);
  }
}

void horizontalblur_free(effect *effect) {
  free(effect->data);
}

void horizontalblur_new(effect *effect) {
  effect->run=horizontalblur_run;
  effect->new=horizontalblur_new;
  effect->freee=horizontalblur_free;
  effect->data=(horizontalblur_data *)calloc(sizeof(horizontalblur_data), 1);
}
