/* production.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <math.h>
#include "production.h"
#include "effect.h"

extern int quit;
extern effectlistentry *effectlist;

/* Quit the program */
void production_quit()
{
  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  quit=1;
}

/* Implement these in a production specific file */
#ifdef implement_these_in_production_specific_file
int renderwidth=352, renderheight=288, screenwidth=640, screenheight=480;
char *production_window_title, *production_mp3_filename;
void production_startup() {}
void production_shutdown() {}

/* The timeline entries */
timelineentry timeline[] =
{
  { 128*60000/125, production_quit }
};
#endif
