/* tg03demo01.c */

#include "tg03demo.h"

extern int sinus[1024];

#define STEPS2TIME(steps)   (SONGPOSTOTIME(0,steps) - SONGPOSTOTIME(0, 0))
static const int a1 = STEPS2TIME(48);
static const int a2 = STEPS2TIME(48 + 32);

static void params_01_copy_a1(void *d, long time)
{
   static t = 0;
   copy_data *data=(copy_data *)d;

   // First pass
   if(t == 0)
   {
      t = time;
   }
   else
   {
      if((time - t) > a1 && (time - t) < a2)
         data->source = pictures[A2];
      else if ((time - t) > a2)
         data->source = pictures[A3];
   }

   data->alpha = sinus[time/24%1023];
}

static void params_01_verticalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;

  data->amount = 1;

   if(time>=PART_05_START)
   {
      data->amount = 1+(rand()%10);
   }
}

static void params_01_verticalstretch(void *d, long time) {
   verticalstretch_data *data=(verticalstretch_data *)d;
   data->position = sinus[time/20%1023];
   data->length = sinus[(time/32)%1023]%30;
}

void part_01() {
   copy_data *copydata;
   verticalblur_data *vbdata;
   verticalstretch_data *vsdata;
   add_data *adddata;
   twirlripple_data *trdata;
   int rp, pr;

   if(effectlist)
      effectlist_free(effectlist);

   effectlist=NULL;

   // 6. Blur it
   effectlist=effectlistentry_new(effect_new(verticalblur_new, params_01_verticalblur), effectlist);
   vbdata=(verticalblur_data *)effectlist->effect->data;
   vbdata->source=pictures[TEMP];
   vbdata->dest=&screenbuffer;
   vbdata->amount=6;

   // Vertical stretch
   effectlist = effectlistentry_new(effect_new(verticalstretch_new, params_01_verticalstretch), effectlist);
   vsdata = (verticalstretch_data*)effectlist->effect->data;
   vsdata->dest = pictures[TEMP];
   vsdata->position = 0;
   vsdata->length = 0;

   // 3. Copy a1
   effectlist=effectlistentry_new(effect_new(copy_new, params_01_copy_a1),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source        = pictures[A1];
   copydata->dest          = pictures[TEMP];
   copydata->sourcex       = 0;
   copydata->sourcey       = 0;
   copydata->destx         = 72;
   copydata->desty         = 22;
   copydata->sourcewidth   = pictures[A1]->width;
   copydata->sourceheight  = pictures[A1]->height;
   copydata->destwidth     = pictures[A1]->width;
   copydata->destheight    = pictures[A1]->height;
   copydata->alpha         = 255;
   copydata->mode          = COPY_MODE_NORMAL;
   copydata->interpolate   = 0;

   // 1. Clear
   effectlist=effectlistentry_new(effect_new(copy_new, NULL), effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[TEMP];
   copydata->dest=pictures[TEMP];
   copydata->destx=0;
   copydata->desty=0;
   copydata->sourcewidth=pictures[TEMP]->width;
   copydata->sourceheight=pictures[TEMP]->height;
   copydata->destwidth=pictures[TEMP]->width;
   copydata->destheight=pictures[TEMP]->height;
   copydata->alpha=0;
   copydata->mode=COPY_MODE_OVERWRITE;
   copydata->interpolate=0;
}
