/* tg03demo02.c */


#include "tg03demo.h"

extern int sinus[1024];

#define POS SONGPOSTOTIME
#define ANIM_NUM_FRAMES(firstframe, lastframe)  (1+(lastframe)-(firstframe))

static int rand_01=0;

// Anim stuff
static const long animspeed      = POS(0,4)-POS(0,0);   /* Anim speed relative to track positions */
static const long animframesnum  = ANIM_NUM_FRAMES(F001, F004);

static void params_02_copy_gathering(void *d, long time) {
   copy_data *data=(copy_data *)d;
   long x;
   time -= PART_02_START;
   if(time < 0)
      time = 0;

   data->alpha = sinus[(time/20)%1023];
}

static void params_02_copy_y2k(void *d, long time) {
   copy_data *data=(copy_data *)d;
   time -= PART_02_START;
   if(time < 0)
      time = 0;

   data->alpha = sinus[(time/21)%1023];
}

static void params_02_verticalblur(void *d, long time)
{
}

void part_02() {
   copy_data *copydata;
   verticalblur_data *vbdata;
   add_data *adddata;
   twirlripple_data *trdata;
   int rp, pr;

   if(effectlist)
    effectlist_free(effectlist);

   effectlist=NULL;

   // 6. Blur it
   effectlist=effectlistentry_new(effect_new(verticalblur_new, params_02_verticalblur), effectlist);
   vbdata=(verticalblur_data *)effectlist->effect->data;
   vbdata->source=pictures[TEMP];
   vbdata->dest=&screenbuffer;
   vbdata->amount=0;

   // 4. Copy y2k
   effectlist=effectlistentry_new(effect_new(copy_new, params_02_copy_y2k),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[Y2K];
   copydata->dest=pictures[TEMP];
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=165;
   copydata->desty=163;
   copydata->sourcewidth=pictures[Y2K]->width;
   copydata->sourceheight=pictures[Y2K]->height;
   copydata->destwidth=pictures[Y2K]->width;
   copydata->destheight=pictures[Y2K]->height;
   copydata->alpha=0;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;

   // 3. Copy Gathering
   effectlist=effectlistentry_new(effect_new(copy_new, params_02_copy_gathering),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[GATHERING];
   copydata->dest=pictures[TEMP];
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=85;
   copydata->desty=120;
   copydata->sourcewidth=pictures[GATHERING]->width;
   copydata->sourceheight=pictures[GATHERING]->height;
   copydata->destwidth=pictures[GATHERING]->width;
   copydata->destheight=pictures[GATHERING]->height;
   copydata->alpha=0;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;

   // 1. Clear
   effectlist=effectlistentry_new(effect_new(copy_new, NULL),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[TEMP];
   copydata->dest=pictures[TEMP];
   copydata->destx=0;
   copydata->desty=0;
   copydata->sourcewidth=pictures[TEMP]->width;
   copydata->sourceheight=pictures[TEMP]->height;
   copydata->destwidth=pictures[TEMP]->width;
   copydata->destheight=pictures[TEMP]->height;
   copydata->alpha=0;
   copydata->mode=COPY_MODE_OVERWRITE;
   copydata->interpolate=0;
}


