/* tg03demo03.c */

#include "tg03demo.h"

extern int sinus[1024];

static void params_03_horizontalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
}

static void params_03_copy_androids(void *d, long time) {
   copy_data *data=(copy_data *)d;
   if(time<0)
      time=0;
   data->alpha = sinus[time/32%1024]/4;
}

static void params_03_fineffekt(void *d, long time) {
   fineffekt_data *data = (fineffekt_data*)d;
   data->position = sinus[time/8%1023];
   data->length = sinus[(time/32)%1023]%30;
}

static void params_03_verticalblur(void *d, long time) {
   verticalblur_data *data=(verticalblur_data *)d;
   data->amount = sinus[time/16%1024]/16;

}

void part_03() {
   copy_data *copydata;
   fineffekt_data *fedata;
   verticalblur_data *vbdata;

   int i;

   if(effectlist)
      effectlist_free(effectlist);
   effectlist=NULL;

   /* 4. Copy ANDROIDS */
   effectlist=effectlistentry_new(effect_new(copy_new, params_03_copy_androids),
             effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[ANDROIDS2];
   copydata->dest=&screenbuffer;
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=0;
   copydata->desty=0;
   copydata->sourcewidth=pictures[ANDROIDS2]->width;
   copydata->sourceheight=pictures[ANDROIDS2]->height;
   copydata->destwidth=pictures[ANDROIDS2]->width;
   copydata->destheight=pictures[ANDROIDS2]->height;
   copydata->alpha=0x7f;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;

   effectlist=effectlistentry_new(effect_new(verticalblur_new, params_03_verticalblur), effectlist);
   vbdata=(verticalblur_data *)effectlist->effect->data;
   vbdata->source=pictures[TEMP];
   vbdata->dest=&screenbuffer;
   vbdata->amount=30;

   effectlist = effectlistentry_new(effect_new(fineffekt_new, params_03_fineffekt), effectlist);
   fedata = (fineffekt_data*)effectlist->effect->data;
   fedata->dest = pictures[TEMP];
   fedata->position = 0;
   fedata->length = 0;
}
