/* tg03demo06.c */

#include "tg03demo.h"

extern int sinus[1024];

#define POS SONGPOSTOTIME
#define ANIM_NUM_FRAMES(firstframe, lastframe)  (1+(lastframe)-(firstframe))

// Anim stuff
static const long animspeed      = POS(0,64)-POS(0,0);   /* Anim speed relative to track positions */
static const long animframesnum  = ANIM_NUM_FRAMES(TMOFD, ENDLAME);

static void params_06_horizontalblur(void *d, long time) {
   verticalblur_data *data=(verticalblur_data *)d;
   if(time<0)
      time=0;
   data->amount = 1;
}

static void params_06_copy_title(void *d, long time) {
   copy_data *data=(copy_data *)d;
   static long prevtime = 0;
   static int framenum;

   if(prevtime == 0)
   {
      prevtime = time;
      framenum = TMOFD;
   }
   else if(time - prevtime > animspeed)
   {
      prevtime = time;
      if(framenum < ENDLAME)
         framenum++;
   }

   data->source = pictures[framenum];
   data->alpha = 0xff;
}

void part_06() {
   copy_data *copydata;
   horizontalblur_data *hbdata;
   int i;

   if(effectlist)
      effectlist_free(effectlist);
   effectlist=NULL;

   // Blur and put to screenbuffer
   effectlist=effectlistentry_new(effect_new(horizontalblur_new, params_06_horizontalblur), effectlist);
   hbdata=(horizontalblur_data *)effectlist->effect->data;
   hbdata->source=pictures[TEMP];
   hbdata->dest=&screenbuffer;
   hbdata->amount=1;

   // Who did what (credits)
   effectlist=effectlistentry_new(effect_new(copy_new, params_06_copy_title), effectlist);
   copydata=(copy_data *)effectlist->effect->data;
   copydata->source=pictures[WDW];
   copydata->dest=pictures[TEMP];
   copydata->sourcex=0;
   copydata->sourcey=0;
   copydata->destx=0;
   copydata->desty=0;
   copydata->sourcewidth=pictures[WDW]->width;
   copydata->sourceheight=pictures[WDW]->height;
   copydata->destwidth=pictures[WDW]->width;
   copydata->destheight=pictures[WDW]->height;
   copydata->alpha=0x7f;
   copydata->mode=COPY_MODE_NORMAL;
   copydata->interpolate=0;
}
