//
// Composite fade-in/out. Just multiply the frame buffer.
//
// ps1.1, FFP
// 

#include "lib/shared.fx"
#include "lib/structs.fx"

float4	vColor;


SPos vsMain11( SPos i )
{
    SPos o;
	o.pos = i.pos * float4(2,2,1,1);
	return o;
}

half4 psMain11() : COLOR
{
	return vColor;
}

technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain11();
		ZEnable = False;
		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = Zero;
		DestBlend = SrcColor;
	}
	pass PLast {
		ZEnable = True;
		ZWriteEnable = True;
		AlphaBlendEnable = False;
	}
}

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = NULL;
		ZEnable = False;
		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = Zero;
		DestBlend = SrcColor;

		TextureFactor = (vColor);

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = TFactor;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = TFactor;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
	pass PLast {
		ZEnable = True;
		ZWriteEnable = True;
		AlphaBlendEnable = False;
	}
}
