//
// Pyramid filter for blurring. Repeatedly applied produces approximate
// Gaussian blur. As presented by M.Kawase in GDC2003, "Frame Buffer
// Postprocessing Effects"
//
// ps1.1
// 

#include "lib/structs.fx"
  
texture		tBase;
sampler		smpBase = sampler_state {
    Texture   = (tBase);
    MipFilter = None;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Clamp; AddressV = Clamp;
};

// x=0.5/texwidth, y=0.5/texheight, z=1-x*2, w=1-y*2
float4	vFixUV;
float4	vTexelsX;
float4	vTexelsY;


SPosTex4 vsMain11( SPosTex i )
{
    SPosTex4 o;
	o.pos = i.pos * float4(2,2,1,1);
	float2 uv = i.uv + vFixUV.xy;
	for( int i = 0; i < 4; ++i )
		o.uv[i] = uv + float2( vTexelsX[i], vTexelsY[i] );
	return o;
}

half4 psMain11( SPosTex4 i ) : COLOR
{
	int t;
	half4 c = 0;
	for( t = 0; t < 4; ++t ) {
		half4 cc = tex2D( smpBase, i.uv[t] );
		c += cc/4;
	}
	return c;
}

SPosTex2 vsMainFFa( SPosTex i )
{
    SPosTex2 o;
	o.pos = i.pos * float4(2,2,1,1);
	float2 uv = i.uv + vFixUV.xy;
	o.uv[0] = uv + float2( vTexelsX[0], vTexelsY[0] );
	o.uv[1] = uv + float2( vTexelsX[1], vTexelsY[1] );
	return o;
}
SPosTex2 vsMainFFb( SPosTex i )
{
    SPosTex2 o;
	o.pos = i.pos * float4(2,2,1,1);
	float2 uv = i.uv + vFixUV.xy;
	o.uv[0] = uv + float2( vTexelsX[2], vTexelsY[2] );
	o.uv[1] = uv + float2( vTexelsX[3], vTexelsY[3] );
	return o;
}

technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain11();

		ZEnable = False;
		ZWriteEnable = False;
	}
	pass PLast {
		Texture[0] = NULL;
		Texture[1] = NULL;
		Texture[2] = NULL;
		Texture[3] = NULL;
		ZEnable = True;
		ZWriteEnable = True;
	}
}

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMainFFa();
		PixelShader = NULL;

		ZEnable = False;
		ZWriteEnable = False;

		Sampler[0] = (smpBase);
		Sampler[1] = (smpBase);

		TextureFactor = 0x40404040;

		ColorOp[0]	 = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		AlphaOp[0]	 = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = TFactor;

		ColorOp[1]	 = ModulateAlpha_AddColor;
		ColorArg1[1] = Current;
		ColorArg2[1] = Texture;
		AlphaOp[1]	 = SelectArg1;
		AlphaArg1[1] = TFactor;

		ColorOp[2]	 = Disable;
		AlphaOp[2]	 = Disable;
	}
	pass P1 {
		VertexShader = compile vs_1_1 vsMainFFa();

		AlphaBlendEnable = True;
		SrcBlend = One;
		DestBlend = One;

		Sampler[0] = (smpBase);
		Sampler[1] = (smpBase);
	}
	pass PLast {
		Texture[0] = NULL;
		Texture[1] = NULL;

		AlphaBlendEnable = False;

		ZEnable = True;
		ZWriteEnable = True;
	}
}
