#include "lib/shared.fx"
#include "lib/structs.fx"

float4x4	mWorld;
float4x4	mWorldView;
float4x4	mWVP;

float4 	vColor;

texture		tShadow1;
sampler2D	smpShadow1 = sampler_state {
	Texture = <tShadow1>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};
texture		tShadow2;
sampler2D	smpShadow2 = sampler_state {
	Texture = <tShadow2>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

struct SOutput {
	float4 pos : POSITION;
	float4 uvs[2] : TEXCOORD0;
};

SOutput vsMain( SPos i ) {
	SOutput o;
	o.pos = mul( i.pos, mWVP );
	float4 vpos = mul( i.pos, mWorldView );
	o.uvs[0] = mul( vpos, mShadowProj1 );
	o.uvs[1] = mul( vpos, mShadowProj2 );
	return o;
}

half4 psMain( SOutput i ) : COLOR {
	half4 ccol = vColor;
	half4 csh1 = tex2D( smpShadow1, i.uvs[0] );
	half4 csh2 = tex2D( smpShadow2, i.uvs[1] );
	return ccol * csh1 * csh2;
}


technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = compile ps_1_1 psMain();
		TextureTransformFlags[0] = Projected;
		TextureTransformFlags[1] = Projected;
	}
	pass PLast {
		TextureTransformFlags[0] = Disable;
		TextureTransformFlags[1] = Disable;
	}
}

// just the color :)
technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = NULL;

		TextureFactor = (vColor);

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = TFactor;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = TFactor;

		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}
	pass PLast {
	}
}
