///////////////////////////////////////////////////////////////////////
// Super Mario Lngben Bros.
// Copyright (c) 2004 Camilla Drefvenborg <elmindreda@home.se>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////

class GameApp : public ThApplication
{
public:
  GameApp(void);
  bool open(void);
  bool update(float deltaTime);
  bool render(IThCanvas* target);
  bool receive(const IThMessage* message);
private:
  void print(const ThVector2& position, const char* format, ...);
  ThVector2 tileToScreen(const ThVector2& position);
// constants
  enum { RIGHT, LEFT, JUMP, TURBO };
  enum { INTRO, WORLD, GAME, DEATH, OVER, CREDITS, GREETS };
// data
  ThPtr<ThInputMapping> m_mapping;
  ThVector2             m_position;
  ThVector2             m_velocity;
  float                 m_gomba;
  float                 m_scroll;
  float                 m_center;
  unsigned int          m_mode;
  bool                  m_killed;
  unsigned int          m_lives;
  ThTimer               m_timer;
};
