#include "project.h"
	
char* wm_title  = "fly";
long  wm_width  = 800;
long  wm_height = 600;
char  wm_bpp    = 32;

float wm_fov    = 45.0f;
float wm_zNear  = 1.0f;
float wm_zFar   = 150.0f;

bool wm_done = false;
unsigned long wm_StartTime;
unsigned long sync;

int load_NumAll = 10;
int load_NumLoaded = 0;
bool loading = true;
bool waiting = false;

void load_DrawLoader(float percent)
{
	(percent==1)?(percent=0.9f):(percent+=0.1f);
	int magassag = 8;
	int szelesseg = magassag*10;
	int balszel = (wm_width-szelesseg)/2;
	int felszel = (wm_height-magassag)/2;

	//glColor3f(0.7f,0.7f,0.7f);
	glColor3f(0.2f,0.2f,0.2f);
	glBegin(GL_LINE_LOOP);
		glVertex2i(balszel-2, felszel);
		glVertex2i(balszel-2, felszel+magassag+1);
		glVertex2i(balszel+szelesseg, felszel+magassag+1);
		glVertex2i(balszel+szelesseg, felszel);
	glEnd();

	for (int i=1; i<=(int)(percent*10); i++)
	{
		//float szin = 0.36f + i*0.04f;
		float szin = 0.2f + i*0.04f;
		//glColor3f(szin,szin,szin);
		glBegin(GL_QUADS);
			glVertex2i(balszel + (i-1)*magassag, felszel + 1);
			glVertex2i(balszel + (i-1)*magassag, felszel + magassag - 1);
			glVertex2i(balszel + i*magassag - 1, felszel + magassag - 1);
			glVertex2i(balszel + i*magassag - 1, felszel + 1);
		glEnd();
	}
	glColor3f(1,1,1);
}


void wm_DisplayTitle(const char *fmt, ...)
{
	char titletext[256];
	va_list list;
	if (fmt==NULL) return;
	va_start(list,fmt);
	vsprintf(titletext,fmt,list);
	va_end(list);
	SetWindowText(wm_hWnd,titletext);
}

 FILE *f;

int waittex;

inline void Init() 
{
#ifndef MUSIC_OFF
	Music_Init("data/fly.mp3");
#endif

	konyha_init();
	kepek_init();

	f=fopen("data/sync.txt","wt");

	waittex=JPG_UploadJPG3("data/w8.jpg");

	wm_StartTime = timeGetTime();
}

inline void DeInit() 
{
#ifndef MUSIC_OFF
	Music_Close();
#endif

	konyha_deinit();
	kepek_deinit();


	fflush(f);
	fclose(f);
}


inline void MainLoop()
{
	//wm_DisplayTitle("%s | %d (%d.%d)",wm_title,sync,(sync/1000)/60,(sync/1000)%60);
	if (loading) // init 
	{
		set2d(0,0,wm_width,wm_height);
		// load one item, or rather one whole scene //
		load_DrawLoader(((load_NumLoaded++)%load_NumAll)/(float)load_NumAll);
		if (load_NumLoaded==load_NumAll) 
		{
			loading=false;
				#ifdef MUSIC_OFF
					wm_StartTime=timeGetTime();
				#else
					wm_StartTime=0;
					Music_Play();
				#endif
				//wm_StartTime=timeGetTime();
				set3d(wm_fov,(float)wm_width/(float)wm_height,wm_zNear,wm_zFar);
		}
	} else {
		/*if (waiting)
		{
			set2d(0,0,wm_width,wm_height);

			glEnable(GL_TEXTURE_2D);
				glBindTexture(GL_TEXTURE_2D,waittex);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0); glVertex2f((wm_width/2)-128,wm_height-64);
					glTexCoord2f(0,1); glVertex2f((wm_width/2)-128,wm_height);
					glTexCoord2f(1,1); glVertex2f((wm_width/2)+128,wm_height);
					glTexCoord2f(1,0); glVertex2f((wm_width/2)+128,wm_height-64);
				glEnd();
			glDisable(GL_TEXTURE_2D);

			if (timeGetTime()-wm_StartTime>=1)
			{
				waiting=false;
			}
		} else {*/
			// demo
			sync = GetSync;
/*
0.00 - 0.15 : suhogs: befade kifade suhano legycsaporol
0.15 - 0.34 : egy-egy vgigsuhans a kamerval, egyenes vonalban a konyhban, befade kifade
0.34 - 0.48 : kepek fenykepkent be-bevillannak, vegen szoveg: (hatching)
0.48 - 1.02 : titleanim (rblend) kizoom kifade
1.02 - 1.16 : repkeds
1.16 - 1.44 : mszkls (falon, plafonon, asztalon -> szivoka)
 1.22: whitefade, kameravlts, vmi ms
 1.29: -||-

1.44 - 1.51 : celkereszt megjelenik, raall az asztalon egy kajafoltra
 1.51: lecsapjk, parasztbcsi, aztn hirtelen mittomn :)

1.51 - 1.57 : sznet

scroller

1.57 - 2.11 : 
2.11 - 2.32 : 
2.32 - 2.27 : zoomout/stay, show endinfo (breakpoint 2004 vagy fly - 2004)
  */


			if ((sync>0) && (sync<=15627)) //legycsapo 15627
			{				
				konyha_legycsapo(sync);
			} else if ((sync>15627) && (sync<=34761)) // belenez 19134
			{
				konyha_belenez(sync-15627);
			} else if ((sync>34761) && (sync<=48739)) // kepek 13978
			{
				kepek_fenykepek(sync-34761);
			} else if ((sync>48739) && (sync<=62623)) // title 13884
			{
				kepek_title(sync-48739);
			} else if ((sync>62623) && (sync<=76555)) // repked 13932
			{
				konyha_repked(sync-62623);
			} else if ((sync>76555) && (sync<=104394)) // maszkal 27839
			{
				konyha_maszkal(sync-76555);
			} else if ((sync>104394) && (sync<=111313)) // celkereszt 8919
			{
				konyha_celkereszt(sync-104394);
			} else if ((sync>111313) && (sync<=118418)) // szunet 7105
			{
				kepek_bacsi(sync-111313);
			} else if ((sync>118418) && (sync<=159843)) // zoomout 6782
			{
        //kepek_zoomout(sync-153061);
        kepek_endscroller(sync-118418);
			}
      //kepek_fenykepek(sync);
			//kepek_title(sync);
      //konyha_repked(sync);
      //konyha_belenez(sync);

      
      //kepek_bacsi(sync);
      //kepek_endscroller(sync);
      //konyha_maszkal(sync);

			if (sync>=159843) wm_done=true;
			
			wm_DisplayTitle("%s | %d (%d.%d)",wm_title,sync,(sync/1000)/60,(sync/1000)%60);
		//}
      /*(sync<=132164)) // ??? 13746
			{
				kepek
			} else if ((sync>132164) && (sync<=153061)) // ??? 20897 | 34643
			{
        kepek_endscroller(sync-118418);
				//
			} else if ((sync>153061) &&*/
	}

}

//------------------------------------------------------------------
//- THE WINMAIN FUNCTION -------------------------------------------
//------------------------------------------------------------------

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	/*switch (MessageBox(NULL,"Fullscreen?","Screen mode",MB_YESNOCANCEL))
	{
		case IDYES: wm_fullscreen=true; break;
		case IDNO: wm_fullscreen=false; break;
		case IDCANCEL: exit(0); break;
	}*/
	if (!wm_Init(wm_width,wm_height,wm_bpp,true,wm_title,wm_fov,wm_zNear,wm_zFar)) return 0;

	Init();

	MSG	msg;
	while(!wm_done)
	{
 		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			if (msg.message==WM_QUIT)
			{
				wm_done=true;
			}
			else
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else
		{
			if (wm_esc)
			{
				wm_done=true;
			}
			else
			{
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
				glLoadIdentity();

				MainLoop();

				SwapBuffers(wm_hDC);
			}
		}
	}
	DeInit();
	wm_Kill();
	return (msg.wParam);
}