#include "project.h"

void t3DVector_Copy(t3DVector src, t3DVector &dst)
{
	memcpy(dst,src,3*sizeof(float));
}

void t3DVector_Add(t3DVector a, t3DVector b, t3DVector &dst)
{
	for (int i=0; i<3; i++) dst[i]=a[i]+b[i];
}

void t3DVector_Sub(t3DVector a, t3DVector b, t3DVector &dst)
{
	for (int i=0; i<3; i++) dst[i]=a[i]-b[i];
}

void t3DVector_Cross(t3DVector a, t3DVector b, t3DVector &dst)
{
	dst[0]=(a[1]*b[2])-(a[2]*b[1]);
	dst[1]=(a[2]*b[0])-(a[0]*b[2]);
	dst[2]=(a[0]*b[1])-(a[1]*b[0]);
}

void t3DVector_Normalize(t3DVector &v)
{
	float s = my_sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
	if (s==0) return;
	v[0]/=s;
	v[1]/=s;
	v[2]/=s;
}

void t3DVector_GetNormal(t3DVector a, t3DVector b, t3DVector c, t3DVector &dst)
{	
	t3DVector ba,ca;
	t3DVector_Sub(b,a,ba);
	t3DVector_Sub(c,a,ca);
	t3DVector_Cross(ba,ca,dst);
	t3DVector_Normalize(dst);
}