#include "project.h"

void tmx2gl(tmxMatrix mx)
{
	float glmx[16];

	for (int k=0; k<4; k++)
		for (int  l=0; l<4; l++)
			glmx[l*4+k]=mx[l][k];

	glMultMatrixf(glmx);
}

void tmxMulMxVec(tmxMatrix mx, t3DVector vecsrc, t3DVector &vecdest)
{
	vecdest[0]=	vecsrc[0]*mx[0][0]+
				vecsrc[1]*mx[0][1]+
				vecsrc[2]*mx[0][2]+
						  mx[0][3];
	vecdest[1]=	vecsrc[0]*mx[1][0]+
				vecsrc[1]*mx[1][1]+
				vecsrc[2]*mx[1][2]+
						  mx[1][3];
	vecdest[2]=	vecsrc[0]*mx[2][0]+
				vecsrc[1]*mx[2][1]+
				vecsrc[2]*mx[2][2]+
						  mx[2][3];
}

void tmxCpyMx(tmxMatrix source, tmxMatrix &dest)
{
	//memcpy(dest,&source,sizeof(source));
	int i,j;
	for (i=0; i<4; i++)
		for (j=0; j<4; j++)
			dest[i][j]=source[i][j];
}

void tmxMulMx(tmxMatrix m1, tmxMatrix m2, tmxMatrix &dest)
{
/*	int i,j,k;
	float r;
	for (j=0; j<4; j++)
		for (i=0; i<4; i++)
		{
			r = 0.0f;
			for (k=0; k<4; k++)
				r += m1[i][k] * m2[k][j];
			dest[i][j] = r;
		}*/
   int i,j;
   for(i=0; i<4; i++)
      for(j=0; j<4; j++)
         dest[i][j]=m1[0][i]*m2[j][0]+
                    m1[1][i]*m2[j][1]+
                    m1[2][i]*m2[j][2]+
                    m1[3][i]*m2[j][3];
}


void tmxIdentity(tmxMatrix &mx)
{
	mx[0][0]=1;	mx[1][0]=0;	mx[2][0]=0;	mx[3][0]=0;
	mx[0][1]=0;	mx[1][1]=1;	mx[2][1]=0;	mx[3][1]=0;
	mx[0][2]=0;	mx[1][2]=0;	mx[2][2]=1;	mx[3][2]=0;
	mx[0][3]=0;	mx[1][3]=0;	mx[2][3]=0;	mx[3][3]=1;
}

void tmxTranslate(tmxMatrix &mx, float tx, float ty, float tz)
{
	tmxMatrix t,u;
	t[0][0]=1;	t[1][0]=0;	t[2][0]=0;	t[3][0]=tx;
	t[0][1]=0;	t[1][1]=1;	t[2][1]=0;	t[3][1]=ty;
	t[0][2]=0;	t[1][2]=0;	t[2][2]=1;	t[3][2]=tz;
	t[0][3]=0;	t[1][3]=0;	t[2][3]=0;	t[3][3]=1;
	tmxMulMx(mx,t,u);
	tmxCpyMx(u,mx);
}

void tmxScale(tmxMatrix &mx, float sx, float sy, float sz)
{
	tmxMatrix t,u;
	t[0][0]=sx;	t[1][0]=0;	t[2][0]=0;	t[3][0]=0;
	t[0][1]=0;	t[1][1]=sy;	t[2][1]=0;	t[3][1]=0;
	t[0][2]=0;	t[1][2]=0;	t[2][2]=sz;	t[3][2]=0;
	t[0][3]=0;	t[1][3]=0;	t[2][3]=0;	t[3][3]=1;
	tmxMulMx(mx,t,u);
	tmxCpyMx(u,mx);
}

void tmxRotate(tmxMatrix &mx, float rx, float ry, float rz)
{
	tmxMatrix rotx,roty,rotz,temp,temp2;

	rotx[0][0]=1;	rotx[1][0]=0;							rotx[2][0]=0;						rotx[3][0]=0;
	rotx[0][1]=0;	rotx[1][1]=my_cos(rx*my_pi/180.0f);		rotx[2][1]=my_sin(rx*my_pi/180.0f);	rotx[3][1]=0;
	rotx[0][2]=0;	rotx[1][2]=-my_sin(rx*my_pi/180.0f);	rotx[2][2]=my_cos(rx*my_pi/180.0f);	rotx[3][2]=0;
	rotx[0][3]=0;	rotx[1][3]=0;							rotx[2][3]=0;						rotx[3][3]=1;

	roty[0][0]=my_cos(ry*my_pi/180.0f);	roty[1][0]=0;	roty[2][0]=-my_sin(ry*my_pi/180.0f);	roty[3][0]=0;
	roty[0][1]=0;						roty[1][1]=1;	roty[2][1]=0;							roty[3][1]=0;
	roty[0][2]=my_sin(ry*my_pi/180.0f);	roty[1][2]=0;	roty[2][2]=my_cos(ry*my_pi/180.0f);		roty[3][2]=0;
	roty[0][3]=0;						roty[1][3]=0;	roty[2][3]=0;							roty[3][3]=1;

	rotz[0][0]=my_cos(rz*my_pi/180.0f);		rotz[1][0]=my_sin(rz*my_pi/180.0f);	rotz[2][0]=0;	rotz[3][0]=0;
	rotz[0][1]=-my_sin(rz*my_pi/180.0f);	rotz[1][1]=my_cos(rz*my_pi/180.0f);	rotz[2][1]=0;	rotz[3][1]=0;
	rotz[0][2]=0;							rotz[1][2]=0;						rotz[2][2]=1;	rotz[3][2]=0;
	rotz[0][3]=0;							rotz[1][3]=0;						rotz[2][3]=0;	rotz[3][3]=1;

	tmxMulMx(mx,roty,temp);
	tmxMulMx(temp,rotx,temp2);
	tmxMulMx(temp2,rotz,mx);
}