#include "project.h"


float my_sin(float a)
{
	float r;
	__asm
	{
		fld a
		fsin
		fstp r
	}
	return r;
}

float my_cos(float a)
{
	float r;
	__asm
	{
		fld a
		fcos
		fstp r
	}
	return r;
}

float my_sqrt(float n)
{
	float r;
	__asm
	{
		fld n
		fsqrt
		fstp r
	}
	return r;
}

void set2d(int left, int top, int right, int bottom)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(left, right, bottom, top, 0, 1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

void set3d(float fov, float aspect, float znigh, float zfoa)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(fov, aspect, znigh, zfoa);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

unsigned long GetFileSize(char *name)
{
	FILE *f;
	f=fopen(name,"rb");
	fseek(f, 0, SEEK_END);
	unsigned long i=ftell(f);
	fclose(f);
	return i;
}

float Bezier(float p0, float p1, float p2, float p3, float t)
{
/*	float three = 3.0f;
	float c,r;
	// FPU RULEZ! :D
	__asm {
		fld1
		fld t
		fsub

		fld st(0)
		fld st(1)
		fld st(2)
		fld p0
		fmul
		fmul
		fmul		//	a

		fld three
		fld st(2)
		fld t
		fmul
		fmul
		fst c
		fld st(2)
		fld p1
		fmul
		fmul		//	b

		fld c
		fld t
		fld p2
		fmul
		fmul		//	c

		fld t
		fld t
		fld t
		fld p3
		fmul
		fmul
		fmul		//	d

		fadd
		fadd
		fadd
		fstp r		// add them up
	}
	return r;*/
	// the non-fpu version:
	return ((1-t)*(1-t)*(1-t)*p0) + (3*t*(1-t)*(1-t)*p1) + (3*t*t*(1-t)*p2) + (t*t*t*p3);
}

float CatmullRom(float v0, float v1, float v2, float v3, float t)
{
   float P = (v3 - v2) - (v0 - v1);
   float Q = (v0 - v1) - P;
   float R =  v2 - v0;
   return (P*t*t*t) + (Q*t*t) + (R*t) + v1;
}