#include "CameraDX.h"


CameraDX::CameraDX()
{
	m_Speed = 0.1f;

	D3DXMatrixIdentity( &m_D3DViewMatrix );
	m_PosX = 0.0f;
	m_PosY = 0.0f;
	m_PosZ = 0.0f;
	m_Yaw = 0.0f;
	m_Pitch = 0.0f;
	m_Roll = 0.0f;

	m_FOV = D3DX_PI/2;
	m_Aspect = 1.333f;
	m_zNear = 1.0f;
	m_zFar = 1000.0f;
	
	D3DXMatrixPerspectiveFovLH( &m_D3DProjectionMatrix, m_FOV, m_Aspect, m_zNear, m_zFar );
}

CameraDX::~CameraDX()
{
}

D3DXMATRIX *CameraDX::GetViewMatrix()
{
	CreateViewMatrix( m_PosX, m_PosY, m_PosZ, m_Yaw, m_Pitch, m_Roll );
	return &m_D3DViewMatrix;
}

D3DXMATRIX *CameraDX::GetProjectionMatrix()
{
	D3DXMatrixPerspectiveFovLH( &m_D3DProjectionMatrix, m_FOV, m_Aspect, m_zNear, m_zFar );
	return &m_D3DProjectionMatrix;
}

void CameraDX::SetSpeed( float speed )
{
	m_Speed = speed;
}

float CameraDX::GetSpeed()
{
	return m_Speed;
}

void CameraDX::SetPosition( float posX, float posY, float posZ )
{
	m_PosX = posX;
	m_PosY = posY;
	m_PosZ = posZ;
}

float CameraDX::GetPosX()
{
	return m_PosX;
}

float CameraDX::GetPosY()
{
	return m_PosY;
}

float CameraDX::GetPosZ()
{
	return m_PosZ;
}

void CameraDX::SetOrientation( float yaw, float pitch, float roll )
{
	m_Yaw = yaw;
	m_Pitch = pitch;
	m_Roll = roll;
}

void CameraDX::MoveFrontFly( float delta )
{
	m_PosX -= m_Speed * delta * sin( m_Yaw );
	m_PosY += m_Speed * delta * sin( m_Pitch );
	m_PosZ += m_Speed * delta * cos( m_Yaw );
}

void CameraDX::MoveBackFly( float delta )
{
	m_PosX += m_Speed * delta * sin( m_Yaw );
	m_PosY -= m_Speed * delta * sin( m_Pitch );
	m_PosZ -= m_Speed * delta * cos( m_Yaw );

}
void CameraDX::MoveFront( float delta )
{
	m_PosX -= m_Speed * delta * sin( m_Yaw );
	m_PosZ += m_Speed * delta * cos( m_Yaw );
}

void CameraDX::MoveBack( float delta )
{
	m_PosX += m_Speed * delta * sin( m_Yaw );
	m_PosZ -= m_Speed * delta * cos( m_Yaw );
}

void CameraDX::MoveRight( float delta )
{
	m_PosX += m_Speed * delta * sin( m_Yaw + D3DX_PI/2 );
	m_PosZ -= m_Speed * delta * cos( m_Yaw  + D3DX_PI/2 );
}

void CameraDX::MoveLeft( float delta )
{
	m_PosX += m_Speed * delta * sin( m_Yaw - D3DX_PI/2 );
	m_PosZ -= m_Speed * delta * cos( m_Yaw - D3DX_PI/2 );
}

void CameraDX::MoveUp( float delta )
{
	m_PosY += m_Speed * delta;
}

void CameraDX::MoveDown( float delta )
{
	m_PosY -= m_Speed * delta;
}

void CameraDX::SetProjection( float fov, float aspect, float zNear, float zFar )
{
	m_FOV = fov;
	m_Aspect = aspect;
	m_zNear = zNear;
	m_zFar = zFar;
}

void CameraDX::SetPlanes( float zNear, float zFar )
{
	m_zNear = zNear;
	m_zFar = zFar;
}

void CameraDX::SetFOV( float fov )
{
	m_FOV = fov;
}

float CameraDX::GetFOV()
{
	return m_FOV;
}

void CameraDX::CreateViewMatrix( float posX, float posY, float posZ, float yaw, float pitch, float roll )
{
	D3DXMATRIX D3DMatrixYaw;

	D3DXVECTOR3 VectorUp      = D3DXVECTOR3( 0.0f, 1.0f,  0.0f );
	D3DXMatrixRotationAxis( &D3DMatrixYaw, &VectorUp, yaw );

	D3DXMATRIX D3DMatrixPitch;

	D3DXVECTOR3 VectorRight      = D3DXVECTOR3( cos( yaw ), 0.0f,  sin( yaw ) );
	D3DXMatrixRotationAxis( &D3DMatrixPitch, &VectorRight, pitch );

	D3DXMATRIX D3DMatrizRotation;
	D3DXMatrixMultiply( &D3DMatrizRotation, &D3DMatrixPitch, &D3DMatrixYaw );

	D3DXMATRIX D3DMatrixTranslation;
	D3DXMatrixTranslation( &D3DMatrixTranslation, -posX, -posY, -posZ );

	D3DXMatrixMultiply( &m_D3DViewMatrix, &D3DMatrixTranslation, &D3DMatrizRotation );
}