#include "_types.hpp"
#include "_start.hpp"
#include "_startdx.hpp"
#include "_ogg.hpp"
#include "demoutil.hpp"
#include "th.h"


GrowingUglyThing::GrowingUglyThing()
{
	GeoHandle = sSystem->GeoAdd(sFVF_TSPACE3,sGEO_TRI);
	vertices.Init(10000);
	indices.Init(10000);
	Reset();

  sInt tex = sLoadTexture("data\\blah.jpg");
  
  Material.Init();
  Material.ShaderLevel = sPS_13; 
  Material.BaseFlags = smBF_ZOFF|sMBF_BLENDSMOOTH|smBF_NONORMAL|smBF_DOUBLESIDED;
  Material.Color[0] = 0x00d02374;
  Material.Combiner[sMCS_COLOR0] = sMCOA_SET;
  Material.Combiner[sMCS_TEX0] = sMCOA_MUL;
  Material.Combiner[sMCS_TEX3] = sMCOA_ADD;
  Material.Tex[0] = tex;
  Material.Tex[3] = tex;
  Material.TFlags[3] = 0;
  Material.SpecialFlags |= sMSF_PROJSCREEN;

//  Material.Combiner[sMCS_COLOR0] = sMCOA_SET;
  Material.Handle = sSystem->MtrlAdd(&Material);
  sVERIFY(Material.Handle != sINVALID);
}

GrowingUglyThing::~GrowingUglyThing()
{
	sSystem->GeoRem(GeoHandle);
}



void GrowingUglyThing::Reset()
{
	vertices.Resize(4);
	indices.Resize(12);

	sSetMem(&vertices[0],0,4*sizeof(sVertexTSpace3));

	vertices[0].x=0; vertices[0].y=1; vertices[0].z=0;
	vertices[1].x=0; vertices[1].y=-0.5f; vertices[1].z=0.866f;
	vertices[2].x=0.75f; vertices[2].y=-0.5f; vertices[1].z=-0.433f;
	vertices[3].x=-0.75f; vertices[3].y=-0.5f; vertices[1].z=-0.433f;
	
	vertices[0].u=0; vertices[0].v=0;
	vertices[1].u=1; vertices[1].v=0;
	vertices[2].u=0; vertices[2].v=1;
	vertices[3].u=1; vertices[3].v=1;

	indices[0]=0; indices[1]=1; indices[2]=2;
	indices[3]=0; indices[4]=2; indices[5]=3;
	indices[6]=0; indices[7]=3; indices[8]=1;
	indices[9]=1; indices[10]=3; indices[11]=2;

	gspeed=gtime=0;
	time=0;

}

void GrowingUglyThing::Calculate(sF32 tdelta)
{
	gtime-=tdelta;
	if (gtime<0)
	{
		if (vertices.Count<6950 && indices.Count<6950)
		{
			gtime=sGetRnd(10)/3.0f;
			gspeed=(1+sGetRnd(10))/3.0f;
			SplitTriangle(sGetRnd(indices.Count/3));
		}
		else
		{
			gtime=1000;
			gspeed=0;
		}
	}

	sU32 vn=vertices.Count-3; 
	sVertexTSpace3 &v0=vertices[vn]; sVertexTSpace3 &v1=vertices[vn+1]; sVertexTSpace3 &v2=vertices[vn+2];
	
	sVector a,b;
	a.x=v1.x-v0.x; a.y=v1.y-v0.y; a.z=v1.z-v0.z;
	b.x=v2.x-v0.x; b.y=v2.y-v0.y; b.z=v2.z-v0.z;
	sVector n;
	n.Cross3(a,b);
	n.Unit3();
	n.Scale3(gspeed*tdelta);
	v0.x+=n.x; v1.x+=n.x; v2.x+=n.x;
	v0.y+=n.y; v1.y+=n.y; v2.y+=n.y;
	v0.z+=n.z; v1.z+=n.z; v2.z+=n.z;

	time+=tdelta;
}

void GrowingUglyThing::SplitTriangle(sU32 n)
{
	sInt ni=3*n;
	sVERIFY(ni<indices.Count);

	// get triangle and remove it from the list
	sU16 i0=indices[ni]; sU16 i1=indices[ni+1]; sU32 i2=indices[ni+2];
	indices[ni]=indices[indices.Count-3]; indices[ni+1]=indices[indices.Count-2]; indices[ni+2]=indices[indices.Count-1];
	indices.Count-=3;

	sVertexTSpace3 &v0=vertices[i0]; sVertexTSpace3 &v1=vertices[i1]; sVertexTSpace3 &v2=vertices[i2];

	// add three new vertices in the middle of the three edges
	sU32 vn=vertices.Count; vertices.Count+=3;
	sSetMem(&vertices[vn],0,3*sizeof(sVertexTSpace3));
	sVertexTSpace3 &nv0=vertices[vn]; sVertexTSpace3 &nv1=vertices[vn+1]; sVertexTSpace3 &nv2=vertices[vn+2];
	nv0.x=(v1.x+v2.x)/2; nv0.y=(v1.y+v2.y)/2; nv0.z=(v1.z+v2.z)/2; nv0.u=v0.u; nv0.v=v0.v;
	nv1.x=(v2.x+v0.x)/2; nv1.y=(v2.y+v0.y)/2; nv1.z=(v2.z+v0.z)/2; nv1.u=v1.u; nv1.v=v1.v;
	nv2.x=(v0.x+v1.x)/2; nv2.y=(v0.y+v1.y)/2; nv2.z=(v0.z+v1.z)/2; nv2.u=v2.u; nv2.v=v2.v;

	// make seven new faces
	sU32 in=indices.Count; indices.Count+=21;
	indices[in+ 0]=vn+0; indices[in+ 1]=i1; indices[in+ 2]=i2;
	indices[in+ 3]=vn+1; indices[in+ 4]=i2; indices[in+ 5]=i0;
	indices[in+ 6]=vn+2; indices[in+ 7]=i0; indices[in+ 8]=i1;
	indices[in+ 9]=vn+0; indices[in+10]=vn+2; indices[in+11]=vn+1;
	indices[in+12]=vn+0; indices[in+13]=vn+1; indices[in+14]=i2;
	indices[in+15]=vn+1; indices[in+16]=vn+2; indices[in+17]=i0;
	indices[in+18]=vn+2; indices[in+19]=vn+0; indices[in+20]=i1;

}



void GrowingUglyThing::Draw()
{
	sMaterialEnv env;
	sF32 blah[9] = { 1,1,1, 0,0,0, 0,0,-5 };
	sF32 moreblah[3] = { time/13, time/17, time/19 };

	env.Init();
	env.Orthogonal = sMEO_PERSPECTIVE;
	env.CameraSpace.InitSRT(blah);
	env.ModelSpace.InitEulerPI2(moreblah);

	sSystem->MtrlSet(&Material,&env);
//	sSystem->SetState(sD3DRS_FILLMODE,sD3DFILL_WIREFRAME);

	sF32 *fp;
	sU16 *ip;
	sSystem->GeoBegin(GeoHandle,vertices.Count,indices.Count,&fp,&ip);

	sCopyMem(fp,vertices.Array,vertices.Count*sizeof(sVertexStandard));
	sCopyMem(ip,indices.Array,indices.Count*2);

	sSystem->GeoEnd(GeoHandle);
	sSystem->GeoDraw(GeoHandle);
}

void GrowingUglyThing::SetTexture(sInt tex)
{
  Material.Tex[0] = tex;
}

//------------------------------------------------------------------------------------------------------------------


TextWriter::TextWriter()
{
	char tname[256];
	sCopyString(tname,"data\\tXX.jpg",13);
	for (sU32 i=0; i<30; i++)
	{
		tname[6]=i/10+48;
		tname[7]=i%10+48;
		textures[i]=sLoadTexture(tname);
	}

	GeoHandle = sSystem->GeoAdd(sFVF_DOUBLE,sGEO_QUAD);

  Material.Init();
  Material.ShaderLevel = sPS_13; 
  Material.BaseFlags = smBF_ZOFF|smBF_BLENDSMOOTH|smBF_NONORMAL|smBF_DOUBLESIDED;
  Material.Color[0] = 0xff00ff00;
	Material.Combiner[sMCS_COLOR0] = sMCOA_SET;
  Material.Combiner[sMCS_TEX0] = sMCOA_MUL;
  Material.Tex[0] = 0;
  Material.TFlags[0] = smTF_CLAMP;
  Material.Handle = sSystem->MtrlAdd(&Material);

	time=9999;
	n=-1;
	dtime=0;

}

TextWriter::~TextWriter()
{

}

void TextWriter::Update(sF32 tdelta)
{
	time+=tdelta/9.0f;
	if (time>=1.0f)
	{
		time=0;
		n++;
		if (n<30)
			Material.Tex[0]=textures[n];
		else
			Material.Tex[0]=0;

		angle=sGetRnd(10000);
		xpos=(sFGetRnd()-0.5)*0.4;
		ypos=(sFGetRnd()-0.5)*0.8;
	}

	if (time<0.1f) fade=10*time;
	else if (time<0.9f) fade=1;
	else fade=1-10*(time-0.9f);
	fade=3*fade*fade-2*fade*fade*fade;

	dtime-=tdelta;
	if (dtime<=0)
	{
		dtime+=0.1f;
		dxof=sGetRnd(100)*0.0001;
		dyof=sGetRnd(100)*0.0001;
		dang=sGetRnd(100)*0.001;
	}

}

void TextWriter::DrawBgLayer()
{
	if (n<0 || n>=30) return;
	sF32 xoffs=8-time*16;
  Material.Color[0] = 0xff202020;
	DrawQuad(angle,20,xoffs,0);
}

void TextWriter::DrawFgLayer()
{
	if (n<0 || n>=30) return;
	sU32 col=(0x80+sGetRnd(0x60))*fade;

	sF32 scale=1.0f;
	sF32 rot=0;
	for (sU32 i=0; i<4; i++)
	{
	  Material.Color[0] = col*0x10101;
		DrawQuad(rot,scale,xpos+dxof,ypos+dyof);
		rot+=dang;
		scale*=1.01f;
	  col>>=1;
	}
}


void TextWriter::DrawQuad(sF32 rot, sF32 scale, sF32 xoffs, sF32 yoffs)
{
	sInt i,j;
  sMaterialEnv env;
  sF32 *vp;
  static sFRect full = { 0.0f, 0.0f, 1.0f, 1.0f };

	sF32 xs=512.0*scale;
	sF32 ys=64.0*scale;

	sF32 left=xoffs-(xs/2)/800.0;
	sF32 top=yoffs-(ys/2)/600.0;
	sF32 right=left+xs/800.0;
	sF32 bot=top+ys/600.0;

	sFRect scrn = { left, top, right, bot };

	sF32 si=sFSin(rot);
	sF32 co=sFCos(rot);

	sFRect *scr=&scrn;
	sFRect *uv0=0;
	sFRect *uv1=0;
  if(!uv0) uv0 = &full;
  if(!uv1) uv1 = &full;

  env.Init();
  env.Orthogonal = sMEO_NORMALISED;
  sSystem->MtrlSet(&Material,&env);
  sSystem->GeoBegin(GeoHandle,4,0,&vp,0);
  for(i=0;i<4;i++)
  {
    j = i ^ (i >> 1);

		sF32 x=((j & 1) ? scr->x1 : scr->x0) * 2.0f;
		sF32 y=((j & 2) ? scr->y0 : scr->y1) * 2.0f;
  
    *vp++ = x*co+y*si;
    *vp++ = y*co-x*si;
    *vp++ = 1.0f;
    *vp++ = 0.0f;
    *vp++ = (j & 1) ? uv0->x1 : uv0->x0;
    *vp++ = (j & 2) ? uv0->y1 : uv0->y0;
    *vp++ = (j & 1) ? uv1->x1 : uv1->x0;
    *vp++ = (j & 2) ? uv1->y1 : uv1->y0;
  }
  sSystem->GeoEnd(GeoHandle);
  sSystem->GeoDraw(GeoHandle);
}
