#ifndef __AMBIENT_FRAGMENT_HEADER__
#define __AMBIENT_FRAGMENT_HEADER__

#include "globals.h"

#define NUMC 5
#define NUMREC 10

class ambientFragment : public DemoFX
{
private:
	static timeLine* moveTimeLine;
	static Texture* texCircle;

	struct Circles { vec2 pos; float radius; };
	struct Rect { vec2 pos; float w, h, rot; };
	
	Circles circles[NUMC];
	Circles oldCircles[NUMC], newCircles[NUMC];
	
	Rect rects[NUMREC];
	Rect oldRects[NUMREC], newRects[NUMREC];
	
	float time;
	float startMovingTime;
public:
	bool moving;
	virtual void init(void);
	virtual void draw(float dt);
	void startMoving();
	static void prepareData();
};

timeLine* ambientFragment::moveTimeLine;
Texture* ambientFragment::texCircle;

void ambientFragment::startMoving()
{
	startMovingTime = glfwGetTime();
	moving = true;
	for (int i = 0; i < NUMREC; i++) {
		oldRects[i].pos = rects[i].pos;
		oldRects[i].w = rects[i].w;
		oldRects[i].h = rects[i].h;
		oldRects[i].rot = rects[i].rot;
	}
	for (int i = 0; i < NUMC; i++) {
		oldCircles[i].pos = circles[i].pos;
		oldCircles[i].radius = circles[i].radius;
	}
	for (int i = 0; i < NUMC; i++) {
		newCircles[i].pos = vec2(frnd() * 6 - 3, frnd() * 6 - 3);
		newCircles[i].radius = 0.3 + frnd()*0.1;
	}
	for (int i = 0; i < NUMREC; i++) {
		newRects[i].pos = vec2(frnd() * 8 - 4, frnd() * 6 - 3);
		newRects[i].rot = frnd()*360.0;
		newRects[i].w = 0.7 + frnd()*0.7;
		newRects[i].h = 0.13 + frnd()*0.12;
	}
}

void ambientFragment::init()
{
	moving = false;
	alive=true;
	for (int i=0; i<NUMC; i++) {
		circles[i].pos=vec2(frnd()*6-3, frnd()*4-2);
		circles[i].radius=0.3+frnd()*0.1;
	}
	for (int i=0; i<NUMREC; i++) {
		rects[i].pos=vec2(frnd()*8-4, frnd()*6-3);
		rects[i].rot=frnd()*360.0;
		rects[i].w=0.6+frnd()*0.5;
		rects[i].h=0.1+frnd()*0.1;
	}
	time=0.0;
}

void ambientFragment::draw(float dt)
{
	#define FRLEN 2.0

	/*if (time > FRLEN) {
		alive=false;
		return;
	}*/
	#define FRMOVELEN 0.5	//0.5s
	
	if (moving) {
		float tt = (glfwGetTime() - startMovingTime)/FRMOVELEN;
		if (tt > 1.0) {
			moving = false;
		}
		else {
			for (int i = 0; i < NUMC; i++) {
				circles[i].pos = lerp(moveTimeLine->eval(tt), oldCircles[i].pos, newCircles[i].pos);
				circles[i].radius = lerp(moveTimeLine->eval(tt), oldCircles[i].radius, newCircles[i].radius);
			}
			for (int i = 0; i < NUMREC; i++) {
				rects[i].pos = lerp(moveTimeLine->eval(tt), oldRects[i].pos, newRects[i].pos);
				rects[i].rot = lerp(moveTimeLine->eval(tt), oldRects[i].rot, newRects[i].rot);
				rects[i].w = lerp(moveTimeLine->eval(tt), oldRects[i].w, newRects[i].w);
				rects[i].h = lerp(moveTimeLine->eval(tt), oldRects[i].h, newRects[i].h);
			}
		}
	}
	else {
		for (int i = 0; i < NUMREC; i++) rects[i].w += (dt * 0.1);
		for (int i = 0; i < NUMC; i++) circles[i].radius += dt*0.06;
	}

	glPushAttrib(GL_ALL_ATTRIB_BITS);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	glPushMatrix();
	glLoadIdentity();
	glColor4f(1,0,0,0.5);
	for (int i=0; i<NUMREC; i++) {
		glPushMatrix();
		glTranslatef(rects[i].pos[0], rects[i].pos[1], 0);
		glRotatef(rects[i].rot, 0,0,1);
		//glRectf(-0.3, -rects[i].h, rects[i].w, rects[i].h);
		glBegin(GL_QUADS);
		glColor4f(1,0,0,0.0); glVertex2f(-0.3, -rects[i].h);
		glColor4f(1,0,0,0.5); glVertex2f(rects[i].w, -rects[i].h);
		glColor4f(1,0,0,0.5); glVertex2f(rects[i].w, rects[i].h);
		glColor4f(1,0,0,0.0); glVertex2f(-0.3, rects[i].h);
		glEnd();
		//rects[i].w+= (dt*0.1);
		glPopMatrix();
	}
	texCircle->enable();
	texCircle->bind();
	for (int i=0; i<NUMC; i++) {
		if (i & 1) glColor4f(1,0,0,0.6);
		else glColor4f(1,1,1,0.6);
		glPushMatrix();
		glTranslatef(circles[i].pos[0], circles[i].pos[1], 0);
		glScalef(circles[i].radius, circles[i].radius, 1);
		//glScalef(0.3+time/13, 0.3+time/13, 1);
		glBegin(GL_QUADS);
		glTexCoord2f(0,1); glVertex2f(-1,-1);
		glTexCoord2f(1,1); glVertex2f(1, -1);
		glTexCoord2f(1,0); glVertex2f(1, 1);
		glTexCoord2f(0,0); glVertex2f(-1, 1);
		glEnd();
		glPopMatrix();
	}
	texCircle->disable();
	glPopMatrix();

	glPopAttrib();
	
	time+=dt;
	#undef FRLEN
}

void ambientFragment::prepareData()
{
	texCircle = new Texture("data/image4.png");
	moveTimeLine = new timeLine();
	moveTimeLine->load("data/ambientMoveTimeLine.data");
}

#endif
