#ifndef __BLEND_FRAGMENT_HEADER__
#define __BLEND_FRAGMENT_HEADER__

#include "globals.h"

class blendFragment : public DemoFX
{
private:
	float startTime;
public:
	virtual void init();
	virtual void draw(float dt);
};

inline void blendFragment::init()
{
	alive=true;
	startTime=glfwGetTime();
}

inline void blendFragment::draw(float dt)
{
	#define FRLEN 0.6
	float t=glfwGetTime()-startTime;
	float tt=t/FRLEN;

	if (t>FRLEN) {
		alive=false;
		return;
	}

	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glEnable(GL_BLEND);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//glBlendFunc(GL_ONE_MINUS_DST_COLOR, GL_ZERO);
	glBlendFunc(GL_ONE_MINUS_DST_COLOR, GL_ONE_MINUS_SRC_ALPHA);

	glLoadIdentity();

	//glColor4f(1-tt,1-tt,1-tt, tt);
	glColor4f(1,1,1,0.7);
	glBegin(GL_QUADS);
	glVertex2f(-4, -3);
	glVertex2f(4,-3);
	glVertex2f(4,3);
	glVertex2f(-4,3);
	glEnd();

	glPopAttrib();

	#undef FRLEN
}

#endif
