#include "glModel.h"

std::vector<std::string> split(const std::string& str, const std::string& splitter)
{
    std::vector<std::string> result;
    if (!str.empty())
    {
        for (std::string::size_type offset = 0;;)
        {
            std::string::size_type found = str.find(splitter, offset);
            if (found != std::string::npos)
            {
                result.push_back(str.substr(offset, found-offset));
                offset = found + splitter.size();
            }
            else
            {
                result.push_back(str.substr(offset, str.size()-offset));
                break;
            }
        }
    }
    return result;
}

glModel::glModel(const char* fileName)
{
    ifstream F (fileName);
    if (!F) {
        cerr << fileName << " not found" << endl;
        return;
    }
    group.clear();
    glModelGroup *g = NULL;
    while (!F.eof())
    {
        string s;
        getline(F, s);
        vector<string> word = split(s, " ");
        if (word.empty()) continue;
        if (word[0] == "g")
        {
            if (g != NULL) {
                group.push_back(*g);
                delete g;
            }
            g = new glModelGroup;
            g->name = word[1];
        }
        if (word[0] == "v")
            g->vtx.push_back(vec3(atof(word[1].c_str()), atof(word[2].c_str()), atof(word[3].c_str())));
        
        if (word[0] == "vn") 
            g->norm.push_back(vec3(atof(word[1].c_str()), atof(word[2].c_str()), atof(word[3].c_str())));
            
        if (word[0] == "f") {
            glModelGroup::Triangle t;
            t.f[0] = atoi(word[1].c_str());
            t.f[1] = atoi(word[2].c_str());
            t.f[2] = atoi(word[3].c_str());
            g->tri.push_back(t);
        }
    }
    if (g != NULL) {
        group.push_back(*g);
        delete g;
    }
    F.close();
}
    
void glModelGroup::draw()
{
    glColor4fv(color);
    
    glBegin(GL_TRIANGLES);
    for (unsigned int i=0; i<tri.size(); i++)
    {
        Triangle &t = tri[i];
       
        glNormal3fv(norm[t.f[0]].n);
        glVertex3fv(vtx[t.f[0]].n);
        
        //HACK!
        
        //glNormal3fv(norm[t.f[1]].n);
        glVertex3fv(vtx[t.f[1]].n);
        
        //glNormal3fv(norm[t.f[2]].n);
        glVertex3fv(vtx[t.f[2]].n);
    }
    glEnd();
}

