/*  xa-003 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 
 
#include <iostream>
#include "xio.h"
#include "xdm.h"

#ifdef WIN32
	#include <SDL/SDL.h>
#else
	#include <SDL.h>
#endif

#include "xdl.h"
#include "../scene/scene_intro.h"
#include "../scene/scene_rollingcube.h"
#include "../scene/scene_end.h"
#include "../scene/scene_greets.h"

using namespace std;

int main(int argc, char **argv)
{	
	// Set default settings
	xs::warning.printToConsole(true);
	xdl::config cfg;
	cfg.freq = 22050;

#ifdef DEBUG	
	#ifdef WIN32
		cfg.fullscreen = true;
		cfg.sound = true;
	#else
		cfg.fullscreen = false;
		cfg.sound = true;
	#endif
#else
	cfg.fullscreen = true;
	cfg.sound = true;
#endif
	
	cfg.window_title = "xAngle - xa-003: Midsummer";

#if USE_GUI
	// Run Launch GUI
	xdl::Gui gui(argc, argv, &cfg);
	gui.show("        xAngle\nxa-003: Midsummer\n\n    Party release\n\n");
#endif

	// Init I/O
	xio::Manager xio(640, 480, 32, cfg.fullscreen, false, cfg.window_title,	// Video
					 cfg.sound, cfg.freq, 128); // Sound
	xio.sound->setVol(128);

	// Open window and draw loading.
	xio.texture->loadAll("../data/textures");
	xio.video->init();
	xio.video->blitToScreen(xio.texture->get("loading"), 320, 240, 0, 0, -1, true);
	xio.video->update();
	
	// If fullscreen: wait a sec for the monitor to adjust to the
	// new resulution. (need for some monitors, like mine :) / trejs
	if(cfg.fullscreen)
		xio.timer->delay(1000);
	
	// Load textures
	xio.texture->loadAll("../data/textures/flowers");
	xio.texture->loadAll("../data/textures/dancers");
	xio.texture->loadAll("../data/textures/greets");
	xio.texture->loadAll("../data/textures/other");

#ifdef DEBUG
	cout << "DEBUG | Size of loaded textures in memory: " << (float)xio.texture->kbytes/1000 << " MB." << endl;
#endif

	// Init the demo manager
	xdm::Manager xdm(&xio);
	
	// Load scenes
	scene::Intro intro(&xio);
	scene::RollingCube rolling_cube(&xio);
	scene::Greets greets(&xio);
	scene::End end(&xio);

	// This is the order in which the scenes are going to be played
	xdm.add(&intro);
	xdm.add(&rolling_cube);
	xdm.add(&greets);
	xdm.add(&end);
	
	// Run demo
	xio.sound->play("../data/xa-003.xm");
	xdm.runall();
	return 0;
}
