/*  Animation runner
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "gfx_anim.h"
#include <iostream>
#include <cmath>

using namespace std;

namespace gfx
{		
	void Anim::init(xio::Manager *i, float frame_delay)
	{
		xio = i;
		delay = frame_delay;
	}

	void Anim::draw(xio::surface *target, float move, float alpha, bool centralize)
	{
		// Select frame
		runframec += ((((float)1/25)*move)/delay);
		
		// Calculate current timedifference between frames
		timediff = (runframec - (int)runframec);
		
		// Calculate size based upon the current timediff
		size = (animation[(int)runframec].size + timediff * 
				(animation[(int)runframec+1].size - animation[(int)runframec].size));
		
		// Draw frame
		// It draws the current frame, and calculates the x and y based upon
		// the current time between the points (cur-x + (timediff * (next-x - cur-x))).
		xio->video->blit(animation[(int)runframec].texture, target,
			animation[(int)runframec].x + // Current X
			(int)(timediff * ((animation[(int)runframec+1].x - animation[(int)runframec].x))),
			animation[(int)runframec].y + // Current Y
			(int)(timediff * ((animation[(int)runframec+1].y - animation[(int)runframec].y))), // Next-y - Curr-y
			(int)(animation[(int)runframec].texture->w * size),
			(int)(animation[(int)runframec].texture->h * size), alpha, centralize);
		
		// Restart animation at animation end
		if((int)runframec >= addframec-1)
			runframec = 0;
	}
	
	void Anim::addFrame(const char *texture, float size, int x, int y)
	{
		animation[addframec].texture = xio->texture->get(texture);
		animation[addframec].size = size;
		animation[addframec].x = x;
		animation[addframec].y = y;
		addframec++;
	}
}
