/*  Cube
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#ifndef GFX_CUBE
#define GFX_CUBE
 
#include "../base/xdm.h"

namespace gfx
{	
	class Cube {
	public:
		Cube();
		xio::surface *draw(float move, int change, bool wirecube, bool tail, bool edges);
		void init(xio::Manager *i, int size);
	private:
		void drawLine(float x1, float y1, float x2, float y2);
		void render(float xa, float ya, float za);
		
		xio::surface *s;
		xio::Manager *xio;
		float angle, x[8], y[8], z[8], rx[8], ry[8], rz[8], scrx[8], scry[8];
		xio::vector2d *tail;
		bool tail_reset;
		bool wq, tl, ed;
		int height, width;
	};	
}
 
 #endif
