/*  Static noice
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "gfx_noice.h"
#include <iostream>
#include <cmath>

namespace gfx
{
	void Noice::init(xio::Manager *i)
	{
		xio = i;
	}
	
	void Noice::draw(xio::surface *target, int dx, int dy, int width, int height)
	{
		static xio::u32 noise;
		static xio::u32 carry;
		static xio::u32 seed = 0x12345;

   		for(int y = 0; y < height; y++)
		{
			for(int x = 0; x < width; x++)
			{
	 			noise = seed;
	 			noise >>= 3;
	  			noise ^= seed;
	 			carry = noise & 1;
	 			noise >>= 1;
	  			seed >>= 1;
	  			seed |= (carry << 30);
		  		noise &= 0xFF;
				((xio::u32*)target->pixels)[dx+x + (dy+y)*target->w] = noise<<16 | noise<<8 | noise;
			}
		}
	}
}
