/*  xa-003 
*  Copyright (C) Joakim Kolsjö and Anders Asplund 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "scene_rollingcube.h"
#include <cmath>
#include <iostream>
#include <sstream>

#ifdef WIN32
#include "SDL/SDL.h"
#else
#include "SDL.h"
#endif

using namespace std;

// Scene end time
#define END 25500

namespace scene
{
	RollingCube::RollingCube(xio::Manager *i)
	{
		xio = i;
		gfx_noice.init(i);
		gfx_font.init(i, texture("font"));	
		gfx_cube[0].init(i, 10); // Set size
		
		psurface = xio->video->createSurface(640/4, 480/4);
		gfx_plasma.init(i, psurface);
		
		nsurface = xio->video->createSurface(640/4, 480/4);
	}
	
	int RollingCube::draw(long time, float move)
	{
		static float cafade = 0;
		// Shift scene_intro to the left
		static float moveout = 0;
		EVENT(0, 1000)
		{
			if(moveout > -650) {
				moveout -= ((float)((float)(650/1))/25)*move;
				if(moveout < -650)
					moveout = -650;
			}
#ifndef NO_STEX
			blit(texture("introscreen"), (int)moveout, 0, 0, 0, -1, false);
#endif
			for(int i = 0; i<15 ; i++)
				blit(texture("seperator"), 640+(int)moveout, texture("seperator")->h*i, 0, 0, -1, false);
			
			blit(texture("bg0"), 650+(int)moveout, 0, 0, 0, -1, false);
		}
		
		// Draw the normal background
		EVENT(1000, END)//12710)
		{
			blit(texture("bg0"), 0, 0, 0, 0, -1, false);
		}
		
		EVENT(0, 12710)
			gfx_font.draw(xio->video->getScreen(), "Welcome to Midsummer @ Remedy 04", 19+640+(int)moveout, 20, 0, 0, cafade, false);
		
		// Draw the cube's
		EVENT(0, END)
		{
			// Cube's
			static float r0 = 0;
			r0 += (((float)(2*M_PI)/25)*move)*0.6;
			xio::surface *d = gfx_cube[0].draw(move, 4, true, false, true);
			
			EVENT(12710-2000, 12710)
			{
				if(cafade < 1)
				{
					cafade += ((float)((float)(1))/25)*move*0.5;
					if(cafade > 1)
						cafade = 1;
				}
			}
	
			/*EVENT(15000-2000, 15000)
			{
				if(cafade > 0)
				{
					cafade -= ((float)((float)(1))/25)*move*0.5;
					if(cafade < 0)
						cafade = 0;
				}
			}*/		
			
			for(int i = -4; i <= 4; i++)
			{
				if(cafade < 1) {
					blit(d, 650+(int)moveout + (int)(cos(r0+i*0.2)*(i*20)) + 180,
						(int)((sin(r0)*(i*20)) + 220), 0, 0, cafade, false);
				
					blit(d, 650+(int)moveout + (int)((cos(r0+i*0.2+M_PI/2)*(i*20))) + 180,
						(int)((sin(r0+M_PI/2)*(i*20)) + 220), 0, 0, cafade, false);
				}
				if(cafade > 0) {
					blit(d, 650+(int)moveout + (int)((cos(r0+i*0.2)*(i*20)) + (cos(r0)*(i*20))+180+sin(r0)*60),
						(int)((sin(r0)*(i*20)) + 220), 0, 0, 1-cafade, false);
			
					blit(d, 650+(int)moveout + (int)((cos(r0+i*0.2+M_PI/2)*(i*20)) + (cos(r0)*(i*20))+180+sin(r0)*60),
						(int)((sin(r0+M_PI/2)*(i*20)) + 220), 0, 0, 1-cafade, false);					
				}
			}
		}
		
		// Draw the window
		static float alphafade = 0;
		EVENT(1000, END)
		{
			static float wgrow = 0;
			if(wgrow < 1) {
				wgrow += ((float)((float)(1))/25)*move*0.5;
				if(wgrow > 1)
					wgrow = 1;
			}
				
			// Fadeout noice
			EVENT(3000, 5000)
			{
				if(alphafade < 1)
				{
					alphafade += ((float)((float)(1))/25)*move*0.5;
					if(alphafade > 1)
						alphafade = 1;
				}
			}
			
			if(alphafade < 1) {
				gfx_noice.draw(nsurface, 0, 0, (int)(float)(wgrow*640/4), (int)((float)wgrow*480/4));
				blit(nsurface, 420, 200, 0, 0, alphafade, false);
			}
			
			if(alphafade > 0)
			{				
				gfx_plasma.draw(time, 0, 0, -1);

				blit(psurface, 420, 200, 0, 0, 1-alphafade, false);
			}
			drawBorder(420-1, 200-1, (int)(float)(wgrow*640/4+1), (int)(float)(wgrow*480/4+1));

			
		}
		
		EVENT(25000, END)
			gfx_font.draw(xio->video->getScreen(), "Let's dance!", 22*19, 480-5*19, 0, 0, -1, false);
		
		// If scenetime is out, end scene
		if(time >= END) {
			// Save screen when we arrive at the END, we use it in the next scene.
			xio::surface *rcubescreen = xio->video->createSurface(640, 480);
			xio::surface *rcubescreenb = xio->video->createSurface(640, 480);
			xio->texture->add(rcubescreen, "rcubescreen");
			xio->texture->add(rcubescreenb, "rcubescreenb");
			xio->video->blit(xio->video->getScreen(), texture("rcubescreen"), 0, 0, 0, 0, -1, false);
			xio->video->blit(xio->video->getScreen(), texture("rcubescreenb"), 0, 0, 0, 0, -1, false);
			return 1;
		}
		return 0;
	}
	
	
	void RollingCube::drawBorder(int dx, int dy, int width, int height)
	{
		// Top line
		for(int x = 0; x < width; x++)
			xio->video->setPixel(xio->video->getScreen(), dx+x, dy, 255, 255, 255);
		
		// Right line
		for(int y = 0; y < height; y++)
			xio->video->setPixel(xio->video->getScreen(), dx+width, dy+y, 255, 255, 255);
		
		// Bottom line
		for(int x = 0; x < width; x++)
			xio->video->setPixel(xio->video->getScreen(), dx+x, dy+height, 255, 255, 255);
		
		// Left line
		for(int y = 0; y < height; y++)
			xio->video->setPixel(xio->video->getScreen(), dx, dy+y, 255, 255, 255);
	}
	
}
