# show demoscript definitions
import demoscript
print "testing module."
print dir(demoscript)
print "ok."

from demoscript import *
import math
print "initing demo system"

# setup texture manager
tm = TextureManagerSingleton_instance()

# setup scheduler
sched = SchedulerSingleton_instance()

#########################
### Demo starts here. ###
#########################

class CustomOverlay(Overlay):
	def __init__(self):
		Overlay.__init__(self)
		self.scale.setDamping(0.96)
		self.opacity=FixedSlider(0.0,0.0)
		self.opacity.setDamping(0.98)
		
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.scale.setTargetValue(1.3)
			self.opacity.setTargetValue(1)
			
	def __del__(self):	
		Overlay.__del__(self)


class TentacleImageSeq(ImageSeq):
	def __init__(self):
		ImageSeq.__init__(self)
		
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.next()
			
	def __del__(self):	
		ImageSeq.__del__(self)

class KaleidoImageSeq(ImageSeq):
	def __init__(self):
		ImageSeq.__init__(self)
		
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0)|getEvent(EC_NOTE_ON,0,1)|getEvent(EC_NOTE_ON,0,2):
			self.take(4)
			
	def __del__(self):	
		ImageSeq.__del__(self)


class CustomBlur(Blur):
	def __init__(self):
		Blur.__init__(self)
		self.mix.setDamping(0.96)
		self.mix=FixedSlider(0.8,0.8)

	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.mix.setTargetValue(1.0)
			
		if getEvent(EC_NOTE_ON,0,1):
			self.mix.setTargetValue(0.1)
		
						
	def __del__(self):	
		Blur.__del__(self)


class TentacleBlur(Blur):
	def __init__(self):
		Blur.__init__(self)
		self.mix.setDamping(0.96)
		self.mix=FixedSlider(0.4,0.4)

	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.mix.setTargetValue(1.0)
						
	def __del__(self):	
		Blur.__del__(self)


class LogoScene(Scene):
	def __init__(self):
		Scene.__init__(self)
		
		
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.nextCamera()
			
	def __del__(self):	
		Scene.__del__(self)
		
		
class TentacleScene(Scene):
	def __init__(self):
		Scene.__init__(self)
		
		
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.offset.setTargetValue(4000)
			
	def __del__(self):	
		Scene.__del__(self)

class KaleidoScopeScene(Scene):
	def __init__(self):
		Scene.__init__(self)

		
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.offset.setTargetValue(4000)
			
		if getEvent(EC_NOTE_ON,0,1):
			self.nextCamera()
			
	def __del__(self):	
		Scene.__del__(self)

		
class TVScene(Scene):
	def __init__(self):
		Scene.__init__(self)
		
		
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.offset.setTargetValue(8000)
			
	def __del__(self):	
		Scene.__del__(self)
		



class LogoGamma(MGGamma):
	def __init__(self):
		MGGamma.__init__(self)
		self.red=FixedSlider(0.7,0.7)
		self.green=FixedSlider(0.7,0.7)
		
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.red.setTargetValue(1.4)
			self.green.setTargetValue(1.4)
			self.blue.setTargetValue(2)
		
		if getEvent(EC_NOTE_ON,0,2):
			self.red.setTargetValue(0.3)
			self.green.setTargetValue(0.3)
			self.blue.setTargetValue(0.6)

						
	def __del__(self):	
		MGGamma.__del__(self)



## KALEIDOSCOPE SCENE
scn3 = llScene("d:\\ook3.pck")
kaleido = KaleidoScopeScene()
kaleido.setScene(scn3)
kaleido.speed=16000

scn2 = llScene("d:\\ook2.pck")
kaleido1 = KaleidoScopeScene()
kaleido1.setScene(scn2)
kaleido1.speed=16000

scn1 = llScene("d:\\ook.pck")
kaleido0 = KaleidoScopeScene()
kaleido0.setScene(scn1)
kaleido0.speed=16000


ims3=KaleidoImageSeq();

imgs2 = []

def randomPos2(x):
	x.setPos(frand(-0.8,0.8),0)
	x.opacity.setFixPointDamping(0.99)
	

for i in range(20):
	imgs2.append(Image("d:\\strip1.tga"))
	imgs2.append(Image("d:\\strip2.tga"))
	imgs2.append(Image("d:\\k.tga"))

map (randomPos2,imgs2)
map (ims3.addImage,imgs2)


bm = Bitmap("d:\\backdrop4.png")
bm2 = Bitmap("d:\\backdrop3.png")
bm3 = Bitmap("d:\\backdrop2.png")


bm.connectOutput(kaleido,"in")
bm2.connectOutput(kaleido1,"in")
bm3.connectOutput(kaleido0,"in")


## NOISE
vn = VintageNoise();
vn.addBitmap("d:\\dust1.tga");
vn.addBitmap("d:\\dust2.tga");
vn.addBitmap("d:\\dust3.tga");
vn.addBitmap("d:\\dust4.tga");

## SETUP POSTPROCESSING
cm = LogoGamma()
cmap = RGBMap()
cm.connectOutput(cmap,"map")
blur=CustomBlur()
cmap.connectOutput(blur,"in")
blur.connectOutput(vn,"in")
sched.schedule(0,102.015,vn,SI_POST,0)
##

sched.schedule(0,10,kaleido,SI_A,0)
sched.schedule(10,10,kaleido1,SI_A,0)
sched.schedule(20,10,kaleido0,SI_A,0)
sched.schedule(30,10,kaleido,SI_A,0)
sched.schedule(40,10,kaleido1,SI_A,0)
sched.schedule(50,10,kaleido0,SI_A,0)
sched.schedule(60,10,kaleido,SI_A,0)
sched.schedule(70,10,kaleido1,SI_A,0)
sched.schedule(80,10,kaleido0,SI_A,0)
sched.schedule(90,10,kaleido,SI_A,0)
sched.schedule(100,2.015,kaleido1,SI_A,0)

sched.schedule(0,102.015,ims3,SI_SUPER,0)


