
// Image space blur. Renders full-RT texture offset by 0.5 texel with bilinear
// filtering.

#include "_shared.fx"

texture		tBase;
float		fInvTexSize; // eg. 1.0 / 1024.0


// --------------------------------------------------------------------------
//  vertex shader

struct VS_OUTPUT {
	float4 pos	: POSITION;
	float2 uv	: TEXCOORD0;
};

VS_OUTPUT vsMain (
	float4	pos : POSITION,
	float2  uv : TEXCOORD0 )
{
    VS_OUTPUT o;
	o.pos = pos * float4(2,2,1,1);
	o.uv = uv + fInvTexSize;
	return o;
}

// --------------------------------------------------------------------------
//  effect

technique tec0
< bool backToFront = false; float vshader = 1.1; >
{
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();

		ZEnable = False;
		ZWriteEnable = False;

		CullMode = None;

		//Clipping = False;

		Texture[0] = <tBase>;
		MinFilter[0] = Linear;
		MagFilter[0] = Linear;
		MipFilter[0] = None;

		ColorOp[0]	 = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0]	 = SelectArg1;
		AlphaArg1[0] = Texture;
		
		ColorOp[1]	 = Disable;
		AlphaOp[1]	 = Disable;
	}
	pass PLast {
		VertexShader = NULL;
		CullMode = <iCull>;

		//Texture[0] = NULL;

		ZWriteEnable = True;
		ZEnable = True;

		//Clipping = True;
	}
}
