!!ARBvp1.0
PARAM mvp0 = program.local[0];	# ModelViewProj matrix
PARAM mvp1 = program.local[1];	# ModelViewProj matrix
PARAM mvp2 = program.local[2];	# ModelViewProj matrix
PARAM mvp3 = program.local[3];	# ModelViewProj matrix

PARAM mdl0 = program.local[4];	# Model matrix
PARAM mdl1 = program.local[5];	# Model matrix
PARAM mdl2 = program.local[6];	# Model matrix
PARAM mdl3 = program.local[7];	# Model matrix

PARAM lpos = program.local[8];	# light0 position

PARAM epos = program.local[9];	# light0 position

# == Per-vertex inputs ==
ATTRIB iP0 = vertex.position;
ATTRIB iN0 = vertex.normal;
ATTRIB iT0 = vertex.texcoord[0];

# == Temporaries ==
TEMP lDir; # light direction
TEMP vDir; # view direction
TEMP wP0;  # world space position
TEMP wN0;  # world space normal
TEMP Shade;  # Shade value

# == Per-vertex outputs ==
OUTPUT oP0 = result.position;
OUTPUT oC0 = result.color.front.primary;
OUTPUT oT0 = result.texcoord[0];
OUTPUT oT1 = result.texcoord[1];
OUTPUT oT2 = result.texcoord[2];

# == pos to proj space ==
DP4 oP0.x, iP0, mvp0;
DP4 oP0.y, iP0, mvp1;
DP4 oP0.z, iP0, mvp2;
DP4 oP0.w, iP0, mvp3;

# == normal to world space ==
DP3 wN0.x, iN0, mdl0;
DP3 wN0.y, iN0, mdl1;
DP3 wN0.z, iN0, mdl2;

# == pos to world space ==
DP4 wP0.x, iP0, mdl0;
DP4 wP0.y, iP0, mdl1;
DP4 wP0.z, iP0, mdl2;
DP4 wP0.w, iP0, mdl3;

# == compute light dir ==
SUB lDir, lpos, wP0;	

# == normalize light dir ==
DP3 lDir.w, lDir, lDir;
RSQ lDir.w, lDir.w;
MUL lDir.xyz, lDir, lDir.w;

# == compute view dir ==
SUB vDir, epos, wP0;	

# == normalize view dir ==
DP3 vDir.w, vDir, vDir;
RSQ vDir.w, vDir.w;
MUL vDir.xyz, vDir, vDir.w;

# == Compute light shading ==
DP3 Shade.x, lDir, wN0;
MAD Shade, Shade, 0.5, 0.5;
MOV oT0.x, Shade.x;
MOV oT0.y, 0.0;

# == Compute view shading (outline) ==
DP3 Shade.x, vDir, wN0;
MUL Shade, Shade, Shade;
MOV oT1.x, Shade.x;
MOV oT1.y, 0.0;

MOV oT2, iT0;
MOV oC0, 1.0;

END
