#include "texture.h"
#include "general.h"
#include <iostream>
#include <math.h>
#include <gl/glut.h>
#include <windows.h>

#include "defines.h"





float SINTABLE[360];
float COSTABLE[360];
float TANTABLE[360];

//START OF VECTOR CODE
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
VECTOR3::VECTOR3(float X,float Y,float Z):
	x(X),y(Y),z(Z)
{
}

VECTOR3::VECTOR3(VECTOR3& vector):
x(vector.x),y(vector.y),z(vector.z)
{
}

VECTOR3	VECTOR3::operator+(VECTOR3 vector1)
{
		  VECTOR3 result(this->x+vector1.x,this->y+vector1.y,this->z+vector1.z);
		  return result;
}

VECTOR3	VECTOR3::operator-(VECTOR3 vector1)
{
		  VECTOR3 result(this->x-vector1.x,this->y-vector1.y,this->z-vector1.z);
		  return result;
}

const VECTOR3 VECTOR3::operator*(float numb)
{
		  VECTOR3 result(this->x*numb,this->y*numb,this->z*numb);
		  return result;
}

const VECTOR3 VECTOR3::operator/(float numb)
{
		  VECTOR3 result(this->x/numb,this->y/numb,this->z/numb);
		  return result;
}

const VECTOR3 VECTOR3::cross(VECTOR3 vector1)
{
	VECTOR3 result((this->y*vector1.z)-(this->z*vector1.y),
		           (this->z*vector1.x)-(this->x*vector1.z),
				   (this->x*vector1.y)-(this->y*vector1.x));
	
	return result;
}

float VECTOR3::magnitude()
{
	float magnitude(sqrt(((this->x*this->x)+(this->y*this->y)+(this->z*this->z))));
	return magnitude;
}

void VECTOR3::normalize()
{
	float thing=(float)1/magnitude();
 x=x*thing;
 y=y*thing;
 z=z*thing;
}


//END OF VECTOR CODE
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>><
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

void FLOOR::drawFloor(float x,float z)
{
	glDisable(GL_LIGHTING);
	glCullFace(GL_BACK);
		GLfloat mat_diff[]={1.0,1.0,1.0,0.5};
	GLfloat mat_spec[]={1.0,1.0,1.0,1.0};
	GLfloat light_position[] = {0.0,1.0,1.0,0.0};
	GLfloat white_light[] = {1.0,1.0,1.0,1.0};
	GLfloat lmodel_ambient[] ={0.1,0.1,0.1,1.0};
	glShadeModel(GL_SMOOTH);
	glMaterialfv(GL_FRONT,GL_SPECULAR,mat_spec);
	glMaterialf(GL_FRONT,GL_SHININESS,50);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_diff);
	

	static float  sta=0.0;
	static float  ta=0.0;
	//this draws using quad :)
glPushMatrix();
glTranslatef(0.0,-2.8,0.0);
//	glColor4f(1.0,1.0,1.0,1.0);
	
	glBegin(GL_QUADS);

	glTexCoord2f(0.0,0.0);
	glNormal3f(0.0,1.0,0.0);
	glVertex3f(-50.0,0.0,50);

	glTexCoord2f(0.0,1.0);
	glNormal3f(0.0,1.0,0.0);
	glVertex3f(50.0,0.0,50);

	glTexCoord2f(1.0,1.0);
	glNormal3f(0.0,1.0,0.0);
	glVertex3f(50.0,0.0,-50);

	glTexCoord2f(1.0,0.0);
	glNormal3f(0.0,1.0,0.0);
	glVertex3f(-50.0,0.0,-50);
glEnd();

	
/*tex2.activate();
glBegin(GL_QUADS);
	glTexCoord2f(0.0,1.0);
	glNormal3f(0.0,1.0,0.0);
	glVertex3f(-20.0,0.0,-20);

	
	glTexCoord2f(1,1);
	glNormal3f(0.0,1.0,0.0);
	glVertex3f(-20.0,0.0,20);

	glTexCoord2f(1,0);
	glNormal3f(0.0,1.0,0.0);
	glVertex3f(-20.0,20.0,20);

	glTexCoord2f(0,0);
	glNormal3f(0.0,1.0,0.0);
	glVertex3f(-20.0,20.0,-20);






	glEnd();*/
//sta+=0.004;
	
	

	

	
	
}
 
void FLOOR::drawFloor2(float x,float z)
{
	//this draws using recursion, my first thinking recursion.. whoooha!

	
	glBegin(GL_LINES);
	glColor3f(0.0,1.0,0.0);
	glVertex3f(x,0,z);
	glVertex3f(x,0,z+length*grid);
	glEnd();
	if(x==grid)
		return;
	drawFloor2(x+length,z);
	
}


void genSinCosTanTable()
{
//this works on globals
	for(int ang=0; ang <360; ang++)
	{
		//convert angle to radians..
		double theta=(double)ang*3.141592654/180.0;

		//insert next entry into table
		SINTABLE[ang]=sin(theta);
		COSTABLE[ang]=cos(theta);
		TANTABLE[ang]=tan(theta);
	}
}

MATRIX4X4::MATRIX4X4()
{
	//init our strange little matrix :)
	MATRIX[0] =1;
	MATRIX[1] =0;
	MATRIX[2] =0;
	MATRIX[3] =0;
	//next line
	MATRIX[4]=0;
	MATRIX[5]=1;
	MATRIX[6]=0;
	MATRIX[7]=0;
	//next line..
	MATRIX[8]=0;
	MATRIX[9]=0;
	MATRIX[10]=1;
	MATRIX[11]=0;
	//the last line..
	MATRIX[12]=0;
	MATRIX[13]=0;
	MATRIX[14]=0;
	MATRIX[15]=1;
}

MATRIX4X4 MATRIX4X4::operator *(MATRIX4X4 &matrix)
{
	float sum=0;
MATRIX4X4 mtrxRes;

for(int x=0; x<4;x++)
{
	for(int i=0; i<4;i++)
	{
		sum=0;
		for(int b=0;b<4;b++)
		{
			sum+=this->MATRIX[b+(x<<2)]*matrix.MATRIX[(b<<2)+i];
		
		}
		mtrxRes.MATRIX[(x<<2)+i]=sum;
	}
}

return mtrxRes;
}

MATRIX1X4::MATRIX1X4()
{
	MATRIX[0]=0;
	MATRIX[1]=0;
	MATRIX[2]=0;
	MATRIX[3]=1;
}

		
MATRIX1X4 MATRIX1X4::operator*(MATRIX4X4 &matrix4x4)
{
	MATRIX1X4 mtrxRes;
		for(int index=0; index<4;index++)
	{
		//compute dot product from row of ma
		//and column of mb
		float sum = 0; //used to hold result--
		for(int col =0; col <4;col++)
		{
			sum+=(this->MATRIX[col]*matrix4x4.MATRIX[(col<<2)+index]);
		}//end of index.

		//insert resulting col element..
		mtrxRes.MATRIX[index] =sum;
	}//end of col.
		return mtrxRes;
}

void OrthoMode(int left, int top, int right, int bottom)
{
	// This function takes in rectangle coordinates for our 2D view port.
	// What happens below is, we need to change our projection matrix.  To do this,
	// we call glMatrixMode(GL_PROJECTION) to tell OpenGL the current mode we want.
	// Then we push on a new matrix so we can just call glPopMatrix() to return us
	// to our previous projection matrix, but first we will render in ortho mode.
	//  Next, we load a new identity matrix so that everything is initialize before
	// we go into ortho mode.  One we switch to ortho by calling glOrth(), we then
	// want to set our matrix mode to GL_MODELVIEW, which puts us back and ready to
	// render our world using the model matrix.  We also initialize this new model view
	// matrix for our 2D rendering before drawing anything.

	// Switch to our projection matrix so that we can change it to ortho mode, not perspective.
	glMatrixMode(GL_PROJECTION);						

	// Push on a new matrix so that we can just pop it off to go back to perspective mode
	glPushMatrix();									
	
	// Reset the current matrix to our identify matrix
	glLoadIdentity();								

	//Pass in our 2D ortho screen coordinates.like so (left, right, bottom, top).  The last
	// 2 parameters are the near and far planes.
	glOrtho( left, right, bottom, top, 0, 1 );	
	
	// Switch to model view so that we can render the scope image
	glMatrixMode(GL_MODELVIEW);								

	// Initialize the current model view matrix with the identity matrix
	glLoadIdentity();										
}

void PerspectiveMode()										// Set Up A Perspective View
{
	// This function doesn't really go to perspective mode, since we aren't
	// using gluPerspective(), but if you look in OrthoMode(), we push on
	// a matrix once we change to our projection matrix.  All we need to do is
	// pop that matrix off of our stack and it will return to our original perspective
	// matrix.  So, before we pop the current matrix, we need to tell OpenGL which
	// matrix we want to use by changing our current matrix mode to perspective.
	// Then we can go back to our model view matrix and render normally.

	// Enter into our projection matrix mode
	glMatrixMode( GL_PROJECTION );							

	// Pop off the last matrix pushed on when in projection mode (Get rid of ortho mode)
	glPopMatrix();											

	// Go back to our model view matrix like normal
	glMatrixMode( GL_MODELVIEW );							

	// We should be in the normal 3D perspective mode now
}

