Attribute VB_Name = "modPublic"
Public Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Public Declare Function GetTickCount Lib "kernel32.dll" () As Long

Public Type aKing
 ID As Integer
 Lives As Integer
End Type

Public Type aBall
 X As Currency
 Y As Currency
 Ang As Double
 Speed As Double
 TeamTag As Integer
 PickedUp As Integer
 Owner As Integer 'the guy that last had the ball
End Type

Public Type aPlayer
 X As Currency
 Y As Currency
 tX As Integer
 tY As Integer
 XVel As Currency
 YVel As Currency
 Team As Integer
 Speed As Double
 HasTheBall As Boolean
 Killed As Integer
End Type

Public Const TEAM1 As Integer = 1
Public Const TEAM2 As Integer = 2
Public Const DEAD1 As Integer = 3
Public Const DEAD2 As Integer = 4
Public Const Pi = 3.14159265358979

Public Ball As aBall 'the ball
Public Pl() As aPlayer 'the players
Public King(1 To 2) As aKing

Public Const NumPlayers As Integer = 10 'the number of players
Public Const PlayerSpeed As Integer = 4
Public Const BallSpeed As Integer = 5
Public MinTargetingDistance As Integer
Public MinFireingDistance As Integer

Public WD As Integer 'width and height of the court
Public HG As Integer
Public Const OutZone As Integer = 40 'the size of the "dead zone" on each side of the court

Public MaxSpeed As Boolean
Public Faster As Boolean
Public EndFlag As Boolean

Public PicHDC As Long


Public Sub PaintBoard()
With Main
    PicHDC = Main.PicMain.hDC
    .PicMain.Cls
    'paint the lines--------------
    .PicMain.Line (WD / 2, 0)-Step(0, HG)
    .PicMain.Circle (WD / 2, HG / 2), 10
    .PicMain.Line (0, 0)-Step(OutZone, HG), RGB(0, 150, 0), BF
    .PicMain.Line (WD - OutZone, 0)-Step(OutZone, HG), RGB(0, 150, 0), BF
    '-----------------------------
    
    'paint the ball
    .PicMain.Circle (Ball.X, Ball.Y), 4
    
    'paint the players------------
    For a = 1 To UBound(Pl)
        Select Case Pl(a).Team
        Case TEAM1, DEAD1: col = vbBlue
        Case TEAM2, DEAD2: col = vbRed
        'Case DEAD1: col = vbYellow
        'Case DEAD2: col = vbGreen
        End Select
        If a = King(1).ID Or a = King(2).ID Then col = vbWhite
        .PicMain.Line (Pl(a).X - 2, Pl(a).Y - 2)-Step(5, 5), col, BF
    
    Next a
End With
    
End Sub


Public Sub LoadStuff()
    Randomize
    WD = Main.PicMain.ScaleWidth
    HG = Main.PicMain.ScaleHeight
    
    MinFireingDistance = WD / 2
    MinTargetingDistance = (WD / 3)
    
    ReDim Pl(1 To NumPlayers)
    
    'set up the starting possitions
    s1 = 1
    e1 = Int(NumPlayers / 2)
    s2 = Int(NumPlayers / 2) + 1
    e2 = NumPlayers
    For a = s1 To e1
        Pl(a).Team = TEAM1
        Pl(a).X = Int(Rnd * ((WD / 2) - OutZone)) + OutZone
        Pl(a).Y = Rnd * HG
        Pl(a).tX = Pl(a).X: Pl(a).tY = Pl(a).Y
        Pl(a).Speed = (PlayerSpeed / 2) + ((PlayerSpeed / 2) * Rnd)
    Next a
    For a = s2 To e2
        Pl(a).Team = TEAM2
        Pl(a).X = Int(Rnd * ((WD / 2) - OutZone)) + WD / 2
        Pl(a).Y = Rnd * HG
        Pl(a).tX = Pl(a).X: Pl(a).tY = Pl(a).Y
        Pl(a).Speed = (PlayerSpeed / 2) + ((PlayerSpeed / 2) * Rnd)
    Next a
    Pl(s1).X = WD - OutZone / 2:   Pl(s1).tX = Pl(s1).X
    Pl(s2).X = (OutZone / 2):      Pl(s2).tX = Pl(s2).X
    Pl(s1).Y = (HG / 2):           Pl(s1).tY = Pl(s1).Y
    Pl(s2).Y = (HG / 2):           Pl(s2).tY = Pl(s2).Y
    
    Pl(s1).Team = DEAD1 'Team King starts dead
    Pl(s2).Team = DEAD2
    
    King(1).ID = s1
    King(2).ID = s2
    King(1).Lives = 3
    King(2).Lives = 3
    
    GiveBallTo s2 'IIf(Rnd > 0.5, s1, s2) 'give the ball to the team captain on one of the teams
End Sub

Public Sub DoTheBall()
    If Ball.PickedUp Then
        Ball.X = Pl(Ball.PickedUp).X
        Ball.Y = Pl(Ball.PickedUp).Y
    Else
        For a = 0 To Ball.Speed Step 0.1
            Ball.X = Ball.X + (Cos(Ball.Ang) * Ball.Speed * 0.1)
            Ball.Y = Ball.Y - (Sin(Ball.Ang) * Ball.Speed * 0.1)
            CheckColl
        Next a
    End If
    
    If (Ball.Speed < BallSpeed / 3) And Ball.PickedUp = 0 Then Ball.TeamTag = 0 'assume it has hit the ground at this stage. I dont want do to the proper physics in this part, it's not called for
    
    'submit ball to friction
    f = IIf(Ball.TeamTag <> 0, 0.98, 0.92) 'if the teamtag is 0 it is on the ground, and has more friction
    
    Ball.Speed = Ball.Speed * f
End Sub

Public Sub UpdateKings()
Dim T1 As Integer, T2 As Integer
    For a = 1 To UBound(Pl)
        If Pl(a).Team = TEAM1 Then T1 = T1 + 1
        If Pl(a).Team = TEAM2 Then T2 = T2 + 1
    Next a
    If Pl(King(1).ID).Team = TEAM1 Then T1 = T1 - 1
    If Pl(King(2).ID).Team = TEAM2 Then T2 = T2 - 1
    
    
    Pl(King(1).ID).Team = IIf(T1 > 0, DEAD1, TEAM1)
    Pl(King(2).ID).Team = IIf(T2 > 0, DEAD2, TEAM2)
End Sub

Public Sub MovePlayers()
Dim ThrowNow As Boolean
    For a = 1 To UBound(Pl)
    With Pl(a)
        If .HasTheBall Then
            'the player has the ball
            FindTarget a, targetX, targety
            ThrowNow = Sqr((.X - targetX) ^ 2 + (.Y - targety) ^ 2) < MinFireingDistance 'dont throw if target is too far away
            If (.X - 2) < (WD / 2) And (.X + 2) > (WD / 2) Then ThrowNow = True
            If targetX = 0 And targety = 0 Then ThrowNow = False 'dont throw if you cant find a target
            If ThrowNow Then
                ThrowBall targetX, targety
            Else
                .tX = targetX
                .tY = targety
            End If
        Else
            If OnSameTeam(Ball.TeamTag, .Team) Then
                'our team has the ball
                If Round(.X) = .tX And Round(.Y) = .tY Then
NewCoor:
                    X = Rnd * WD
                    Y = Rnd * HG
                    If OnCourt(X, Y) <> .Team Then GoTo NewCoor
                    .tX = X
                    .tY = Y
                End If
            ElseIf Ball.TeamTag = 0 Then
                'the ball is free, try to catch it
                If OnCourt(Ball.X, Ball.Y) = .Team Then
                    'the ball is on our court, try to catch it
                    .tX = Ball.X
                    .tY = Ball.Y
                Else
                    'the ball is on the others court
                End If
            Else
                'the others have the ball, avoid the ball now
                Ang = FindAng(.X, .Y, Ball.X, Ball.Y, 1)
                .tX = .X + 5 * Cos(Ang)
                .tY = .Y - 5 * Sin(Ang)
            End If
        End If
        
        'Check if the player is on his own cort
        If .Team <> OnCourt(.X, .Y) Then
            'if he isn't, first priority is getting back home
            Call GiveCoordOn(.tX, .tY, .Team)
        End If
        
        
        If Round(.X) <> .tX Or Round(.Y) <> .tY Then
            'if the player is not at his target, move him
            Ang = FindAng(.tX, .tY, .X, .Y, 1)
            .XVel = (Cos(Ang) * .Speed / 2) * Rnd + (Cos(Ang) * .Speed / 2)
            .YVel = (Sin(Ang) * .Speed / 2) * Rnd + (Sin(Ang) * .Speed / 2)
            
            X = .X + .XVel
            Y = .Y - .YVel
            
            If IsThisMoveOk(.X, Y, a) Then
                .Y = Y
            End If
            If IsThisMoveOk(X, .Y, a) Then
                .X = X
            End If
            
        End If
        
        CheckForBallImpact a
        
    End With
    Next a
End Sub

Sub CheckForBallImpact(p)
    'this sub checks if player a can pickup the ball, or if he has been hit by it
    If Ball.PickedUp Then Exit Sub 'quit if someone is carrying the ball
    
    If Ball.TeamTag Then
        'add a little radius if the ball is thrown
         gx = Abs(Cos(Ball.Ang) * 2)
         gy = Abs(Sin(Ball.Ang) * 2)
    End If
    
    If (Pl(p).X - 4 - gx) < Ball.X And (Pl(p).X + 4 + gx) > Ball.X Then
    If (Pl(p).Y - 4 - gy) < Ball.Y And (Pl(p).Y + 4 + gy) > Ball.Y Then
        If Ball.TeamTag = 0 Then
            'BALL PICKUP-------------
            'the ball is on the ground
            If Pl(p).Team = OnCourt(Pl(p).X, Pl(p).Y) Then 'A player can only pick up the ball if he is on his own cort
                Pl(p).HasTheBall = True
                Ball.PickedUp = p
                Ball.TeamTag = Pl(p).Team
            End If
        Else
            'the ball is in the air
            If Ball.TeamTag = Pl(p).Team Then
                'TEAM HIT------------
                'the ball was thrown by someone on my team
                'do nothing for now
            Else
                'PLAYER HIT----------
                'the ball was thrown by the other team, player P's hit
                If Pl(p).Team = TEAM1 Or Pl(p).Team = TEAM2 Then
                    If p = King(Pl(p).Team).ID Then 'if this is a king that has been hit
                        'remove a life
                        King(Pl(p).Team).Lives = King(Pl(p).Team).Lives - 1
                    Else
                        'someone else is hit
                        Pl(p).Team = IIf(Pl(p).Team = TEAM1, DEAD1, DEAD2)
                    End If
                End If
                
                t = (Ball.Owner)
                If Pl(t).Team = DEAD1 And t <> King(1).ID Then Pl(t).Team = TEAM1  'if the guy that threw the ball
                If Pl(t).Team = DEAD2 And t <> King(2).ID Then Pl(t).Team = TEAM2  'was dead, free him
                
                Ball.TeamTag = 0 'the ball is now free
                Ball.Speed = Ball.Speed / 2 'reduce it's speed
            End If
            ' Do something that reflects the ball
'            Ball.Ang = Ang + (Rnd * Pi)
'            Ball.Ang = Ball.Ang Mod Pi
        End If
    End If
    End If
End Sub

Function IsThisMoveOk(X, Y, p) As Boolean
    'this function tells if the player can move to these coordinates
    IsThisMoveOk = True
    
    If Y < 0 Then IsThisMoveOk = False
    If Y > HG Then IsThisMoveOk = False

End Function

Sub ThrowBall(tX, tY)
    'throws the ball at target (tx,tY)
    
    
    'update the player that had the ball
    Pl(Ball.PickedUp).HasTheBall = False
    
    
    'update the ball
    Ball.Owner = Ball.PickedUp
    Ball.PickedUp = 0
    Ang = FindAng(tX, tY, Ball.X, Ball.Y, 1)
    Ball.Ang = Ang
    Ball.Speed = BallSpeed
End Sub


Function FindTarget(p, X, Y)
Dim TotalX As Integer
Dim TotalY As Integer
Dim I As Integer
Dim AddThis As Boolean
Dim MinDis As Double
Dim ClosestGuy As Integer

    MinDis = 10000 'the minimum distance to the closest guy
                   'it's set high so that the first guy checked allways is closer
    
    'Find average target---------------------
    For a = 1 To UBound(Pl)
        AddThis = False
        Select Case Pl(p).Team
        Case TEAM1: If Pl(a).Team = TEAM2 Then AddThis = True
        Case TEAM2: If Pl(a).Team = TEAM1 Then AddThis = True
        Case DEAD1: If Pl(a).Team = TEAM2 Then AddThis = True
        Case DEAD2: If Pl(a).Team = TEAM1 Then AddThis = True
        End Select
        
        If OnWayHome(a) Then AddThis = False
        If AddThis Then
            'an opponent
            TotalX = TotalX + Pl(a).X
            TotalY = TotalY + Pl(a).Y
            I = I + 1
            
            'find the distance to this guy
            D = Abs(Pl(p).X - Pl(a).X) + Abs(Pl(p).Y - Pl(a).Y)
            If D < MinDis Then
                MinDis = D
                ClosestGuy = a
            End If
        End If
    Next a
    '-----------------------------------------
    If MinDis < MinTargetingDistance Then 'A guy is so close
        'that the player shouldaim at him
        X = Pl(ClosestGuy).X
        Y = Pl(ClosestGuy).Y
    Else
        'No players are close, aim at the centre of the other team
        If I > 0 Then
            X = TotalX / I
            Y = TotalY / I
        End If
    End If
End Function


Public Function FindAng(X, Y, Sx, Sy, RAD) 'convert as set of coordinates to the angle between them (given standard VB scales)

Dim Ang As Currency
    If Y - Sy = 0 Then
        Ang = IIf(X >= Sx, 0, Pi)
    Else
        Ang = Atn((X - Sx) / (Y - Sy))
        Ang = Ang + (Pi / 2)
        If Y >= Sy Then
            Ang = Pi + Ang
        End If
    End If
    If RAD = 0 Then Ang = Ang / Pi * 180
    FindAng = Ang
End Function

Sub GiveBallTo(p)
    Ball.PickedUp = p
    Ball.TeamTag = Pl(p).Team
    Pl(p).HasTheBall = True
End Sub

Function OnCourt(X, Y) As Integer
    'returns whos court the ball is in
    If X < (WD / 2) And X > OutZone Then OnCourt = TEAM1
    If X > (WD / 2) And X < (WD - OutZone) Then OnCourt = TEAM2
    If X < OutZone And X > 0 Then OnCourt = DEAD2
    If X > WD - OutZone And X < WD Then OnCourt = DEAD1
End Function

Public Sub CheckColl()
    If Ball.X > WD Then
        Ball.TeamTag = 0 'if the ball hits the wall, it's free
        Ball.X = WD
        Ball.Ang = FindAng(-Cos(Ball.Ang), -Sin(Ball.Ang), 0, 0, 1)
    End If
    If Ball.X < 0 Then
        Ball.TeamTag = 0 'if the ball hits the wall, it's free
        Ball.X = 0
        Ball.Ang = FindAng(-Cos(Ball.Ang), -Sin(Ball.Ang), 0, 0, 1)
    End If
    If Ball.Y < 0 Then
        Ball.TeamTag = 0 'if the ball hits the wall, it's free
        Ball.Y = 0
        Ball.Ang = FindAng(Cos(Ball.Ang), Sin(Ball.Ang), 0, 0, 1)
    End If
    If Ball.Y > HG Then
        Ball.TeamTag = 0 'if the ball hits the wall, it's free
        Ball.Y = HG
        Ball.Ang = FindAng(Cos(Ball.Ang), Sin(Ball.Ang), 0, 0, 1)
    End If
End Sub
Function OnSameTeam(T1, T2) As Boolean
    'Determines if T1 and T2 are on the same team
    If T1 = T2 Then OnSameTeam = True
    If T1 = TEAM1 And T2 = DEAD1 Then OnSameTeam = True
    If T1 = DEAD1 And T2 = TEAM1 Then OnSameTeam = True
    If T1 = TEAM2 And T2 = DEAD2 Then OnSameTeam = True
    If T1 = DEAD2 And T2 = TEAM2 Then OnSameTeam = True
End Function
Sub GiveCoordOn(X, Y, C)
    'This sub sets X and Y to a coordinate on the cort C
noGood:
    DoEvents 'in case of lockups
    X = Int(Rnd * WD)
    Y = Int(Rnd * HG)
    If C <> OnCourt(X, Y) Then GoTo noGood
End Sub
Public Sub CheckForAWinner()
Dim Winner As Integer
    If King(TEAM1).Lives <= 0 Then Winner = TEAM2
    If King(TEAM2).Lives <= 0 Then Winner = TEAM1
    If Winner Then
        aw = MsgBox("Team " & Winner & " won the game. Restart?", vbYesNo + vbInformation)
        EndFlag = True 'flag the game for termination
        If aw = vbNo Then End
    End If
End Sub

Function OnWayHome(p) As Boolean
'this function returns true if a player is on his way home.
'Really it is true if he is left or right of his team's side of the field
    If Pl(p).X + 2 < WD / 2 And Pl(p).Team = TEAM2 Then OnWayHome = True
    If Pl(p).X - 2 > WD / 2 And Pl(p).Team = TEAM1 Then OnWayHome = True
End Function
